/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.syncope;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.login.FailedLoginException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.exceptions.AccountDisabledException;
import org.apereo.cas.authentication.exceptions.AccountPasswordMustChangeException;
import org.apereo.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.model.support.syncope.SyncopeAuthenticationProperties;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.syncope.SyncopeUserTOConverterUtils;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class SyncopeAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncopeAuthenticationHandler.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final SyncopeAuthenticationProperties properties;
    private final String syncopeDomain;

    public SyncopeAuthenticationHandler(SyncopeAuthenticationProperties properties, ServicesManager servicesManager, PrincipalFactory principalFactory, String syncopeDomain) {
        super(properties.getName(), servicesManager, principalFactory, Integer.valueOf(properties.getOrder()));
        this.properties = properties;
        this.syncopeDomain = syncopeDomain;
    }

    protected AuthenticationHandlerExecutionResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential, String originalPassword) {
        Optional<JsonNode> result = this.authenticateSyncopeUser(credential);
        if (result.isPresent()) {
            JsonNode user = result.get();
            LOGGER.debug("Received user object as [{}]", (Object)user);
            if (user.has("suspended") && user.get("suspended").asBoolean()) {
                throw new AccountDisabledException("Could not authenticate forbidden account for " + credential.getUsername());
            }
            if (user.has("mustChangePassword") && user.get("mustChangePassword").asBoolean()) {
                throw new AccountPasswordMustChangeException("Account password must change for " + credential.getUsername());
            }
            Principal principal = this.principalFactory.createPrincipal(user.get("username").asText(), SyncopeUserTOConverterUtils.convert(user, this.properties.getAttributeMappings()));
            return this.createHandlerResult((Credential)credential, principal, new ArrayList(0));
        }
        throw new FailedLoginException("Could not authenticate account for " + credential.getUsername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Optional<JsonNode> authenticateSyncopeUser(UsernamePasswordCredential credential) throws Exception {
        HttpResponse response;
        block2: {
            Optional<JsonNode> optional;
            response = null;
            try {
                String syncopeRestUrl = StringUtils.appendIfMissing((String)this.properties.getUrl(), (CharSequence)"/rest/users/self", (CharSequence[])new CharSequence[0]);
                HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).url(syncopeRestUrl).basicAuthUsername(credential.getUsername()).basicAuthPassword(credential.toPassword()).headers(CollectionUtils.wrap((String)"X-Syncope-Domain", (Object)this.syncopeDomain)).build();
                response = Objects.requireNonNull(HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec));
                LOGGER.debug("Received http response status as [{}]", (Object)response.getStatusLine());
                if (response.getStatusLine().getStatusCode() != 200) break block2;
                String result = EntityUtils.toString((HttpEntity)response.getEntity());
                LOGGER.debug("Received user object as [{}]", (Object)result);
                optional = Optional.of(MAPPER.readTree(result));
            }
            catch (Throwable throwable) {
                HttpUtils.close(response);
                throw throwable;
            }
            HttpUtils.close((HttpResponse)response);
            return optional;
        }
        HttpUtils.close((HttpResponse)response);
        return Optional.empty();
    }
}

