/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.syncope.common.lib.to.AccessTokenTO;
import org.apache.syncope.common.lib.to.PagedResult;
import org.apache.syncope.common.rest.api.beans.AccessTokenQuery;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="AccessTokens")
@Path(value="accessTokens")
public interface AccessTokenService
extends JAXRSService {
    @Operation(security={@SecurityRequirement(name="BasicAuthentication")})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="JWT successfully generated", headers={@Header(name="X-Syncope-Token", schema=@Schema(type="string"), description="Generated JWT"), @Header(name="X-Syncope-Token-Expire", schema=@Schema(type="string"), description="Expiration of the generated JWT")}), @ApiResponse(responseCode="401", description="Invalid username or password")})
    @POST
    @Path(value="login")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response login();

    @Operation(security={@SecurityRequirement(name="Bearer")})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="JWT successfully refreshed", headers={@Header(name="X-Syncope-Token", schema=@Schema(type="string"), description="Generated JWT"), @Header(name="X-Syncope-Token-Expire", schema=@Schema(type="string"), description="Expiration of the refreshed JWT")})})
    @POST
    @Path(value="refresh")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response refresh();

    @Operation(security={@SecurityRequirement(name="Bearer")})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="logout")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void logout();

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @GET
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public PagedResult<AccessTokenTO> list(@BeanParam AccessTokenQuery var1);

    @Operation(security={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@PathParam(value="key") String var1);
}

