/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationCredentialsThreadLocalBinder;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20UserProfileEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UserProfileEndpointController.class);

    public OAuth20UserProfileEndpointController(T configurationContext) {
        super(configurationContext);
    }

    protected static ResponseEntity buildUnauthorizedResponseEntity(String code) {
        LinkedMultiValueMap map = new LinkedMultiValueMap(1);
        map.add((Object)"error", (Object)code);
        String value = OAuth20Utils.toJson(map);
        return new ResponseEntity((Object)value, HttpStatus.UNAUTHORIZED);
    }

    @PostMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handlePostRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.handleGetRequest(request, response);
    }

    @GetMapping(path={"/oauth2.0/profile"}, produces={"application/json"})
    public ResponseEntity<String> handleGetRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("application/json");
        Pair accessTokenResult = (Pair)FunctionUtils.doAndHandle(() -> this.getAccessTokenFromRequest(request));
        if (accessTokenResult == null) {
            LOGGER.error("Unable to get the access token from the request");
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("invalid_request");
        }
        String decodedAccessTokenId = (String)accessTokenResult.getValue();
        if (StringUtils.isBlank((CharSequence)decodedAccessTokenId)) {
            LOGGER.error("Missing required parameter [{}] from the request", (Object)"access_token");
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("missing_accessToken");
        }
        OAuth20AccessToken accessTokenTicket = (OAuth20AccessToken)FunctionUtils.doAndHandle(() -> {
            OAuth20AccessToken state = (OAuth20AccessToken)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(decodedAccessTokenId, OAuth20AccessToken.class);
            return state == null || state.isExpired() ? null : state;
        });
        if (accessTokenTicket == null || accessTokenTicket.isExpired()) {
            LOGGER.error("Access token [{}] cannot be found in the ticket registry or has expired.", (Object)decodedAccessTokenId);
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("expired_accessToken");
        }
        LoggingUtils.protocolMessage((String)"OAuth/OpenID Connect User Profile Request", Map.of("Access Token", decodedAccessTokenId, "Client ID", accessTokenTicket.getClientId()));
        try {
            this.validateAccessToken((String)accessTokenResult.getKey(), accessTokenTicket, request, response);
        }
        catch (Exception e2) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e2);
            return OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("invalid_request");
        }
        return (ResponseEntity)FunctionUtils.doAndHandle(() -> {
            AuthenticationCredentialsThreadLocalBinder.bindCurrent((Authentication)accessTokenTicket.getAuthentication());
            this.updateAccessTokenUsage(accessTokenTicket);
            JEEContext context = new JEEContext(request, response);
            Map map = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getUserProfileDataCreator().createFrom(accessTokenTicket, context);
            return ((OAuth20ConfigurationContext)this.getConfigurationContext()).getUserProfileViewRenderer().render(map, accessTokenTicket, response);
        }, e -> OAuth20UserProfileEndpointController.buildUnauthorizedResponseEntity("invalid_request")).get();
    }

    protected void validateAccessToken(String accessTokenId, OAuth20AccessToken accessToken, HttpServletRequest request, HttpServletResponse response) {
    }

    protected void updateAccessTokenUsage(OAuth20AccessToken accessTokenTicket) throws Exception {
        accessTokenTicket.update();
        if (accessTokenTicket.isExpired()) {
            ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().deleteTicket(accessTokenTicket.getId());
        } else {
            ((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().updateTicket((Ticket)accessTokenTicket);
        }
    }

    protected Pair<String, String> getAccessTokenFromRequest(HttpServletRequest request) {
        String authHeader;
        String accessToken = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("access_token"), (CharSequence)request.getParameter("token"));
        if (StringUtils.isBlank((CharSequence)accessToken) && StringUtils.isNotBlank((CharSequence)(authHeader = request.getHeader("Authorization"))) && authHeader.toLowerCase().startsWith("Bearer".toLowerCase() + " ")) {
            accessToken = authHeader.substring("Bearer".length() + 1);
        }
        LOGGER.debug("[{}]: [{}]", (Object)"access_token", (Object)accessToken);
        return Pair.of((Object)accessToken, (Object)this.extractAccessTokenFrom(accessToken));
    }
}

