/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public final class SyncDelta {
    private final SyncToken token;
    private final SyncDeltaType deltaType;
    private final Uid previousUid;
    private final ObjectClass objectClass;
    private final Uid uid;
    private final ConnectorObject connectorObject;

    SyncDelta(SyncToken token, SyncDeltaType deltaType, Uid previousUid, ObjectClass objectClass, Uid uid, ConnectorObject object) {
        Assertions.nullCheck(token, "token");
        Assertions.nullCheck((Object)deltaType, "deltaType");
        Assertions.nullCheck(uid, "uid");
        if (previousUid != null && (deltaType == SyncDeltaType.DELETE || deltaType == SyncDeltaType.CREATE)) {
            throw new IllegalArgumentException("The previous Uid can only be specified for create_or_update or update.");
        }
        if (object == null && deltaType != SyncDeltaType.DELETE) {
            throw new IllegalArgumentException("ConnectorObject must be specified for anything other than delete.");
        }
        if (object != null && !uid.attributeEquals(object.getUid())) {
            throw new IllegalArgumentException("Uid does not match that of the object.");
        }
        if (object != null && !objectClass.equals(object.getObjectClass())) {
            throw new IllegalArgumentException("ObjectClass does not match that of the object.");
        }
        this.token = token;
        this.deltaType = deltaType;
        this.previousUid = previousUid;
        this.objectClass = objectClass;
        this.uid = uid;
        this.connectorObject = object;
    }

    public Uid getPreviousUid() {
        return this.previousUid;
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public Uid getUid() {
        return this.uid;
    }

    public ConnectorObject getObject() {
        return this.connectorObject;
    }

    public SyncToken getToken() {
        return this.token;
    }

    public SyncDeltaType getDeltaType() {
        return this.deltaType;
    }

    public String toString() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("Token", this.token);
        values.put("DeltaType", (Object)this.deltaType);
        values.put("PreviousUid", this.previousUid);
        values.put("ObjectClass", this.objectClass);
        values.put("Uid", this.uid);
        values.put("Object", this.connectorObject);
        return ((Object)values).toString();
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.deltaType.hashCode();
        result = 31 * result + (this.previousUid != null ? this.previousUid.hashCode() : 0);
        result = 31 * result + (this.objectClass != null ? this.objectClass.hashCode() : 0);
        result = 31 * result + this.uid.hashCode();
        result = 31 * result + (this.connectorObject != null ? this.connectorObject.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof SyncDelta) {
            SyncDelta other = (SyncDelta)o;
            if (!this.token.equals(other.token)) {
                return false;
            }
            if (!this.deltaType.equals((Object)other.deltaType)) {
                return false;
            }
            if (this.previousUid == null ? other.previousUid != null : !this.previousUid.equals(other.previousUid)) {
                return false;
            }
            if (this.objectClass == null ? other.objectClass != null : !this.objectClass.equals(other.objectClass)) {
                return false;
            }
            if (!this.uid.equals(other.uid)) {
                return false;
            }
            return !(this.connectorObject == null ? other.connectorObject != null : !this.connectorObject.equals(other.connectorObject));
        }
        return false;
    }
}

