/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.introspection;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20IntrospectionEndpointController;
import org.apereo.cas.support.oauth.web.response.introspection.BaseOAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenSuccessResponse;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OidcIntrospectionEndpointController
extends OAuth20IntrospectionEndpointController<OidcConfigurationContext> {
    public OidcIntrospectionEndpointController(OidcConfigurationContext context) {
        super((OAuth20ConfigurationContext)context);
    }

    @GetMapping(consumes={"application/x-www-form-urlencoded", "application/json"}, produces={"application/json"}, value={"/oidc/introspect", "/**/introspect"})
    public ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse> handleRequest(HttpServletRequest request, HttpServletResponse response) {
        JEEContext webContext = new JEEContext(request, response);
        if (!((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().validateIssuer((WebContext)webContext, "introspect")) {
            String body = OAuth20Utils.toJson((Object)OAuth20Utils.getErrorResponseBody((String)"invalid_request", (String)"Invalid issuer"));
            return new ResponseEntity((Object)body, HttpStatus.BAD_REQUEST);
        }
        return super.handleRequest(request, response);
    }

    @PostMapping(consumes={"application/json", "application/x-www-form-urlencoded"}, produces={"application/json"}, value={"/oidc/introspect", "/**/introspect"})
    public ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse> handlePostRequest(HttpServletRequest request, HttpServletResponse response) {
        return super.handlePostRequest(request, response);
    }

    protected OAuth20IntrospectionAccessTokenSuccessResponse createIntrospectionValidResponse(String accessTokenId, OAuth20Token ticket) {
        OAuth20IntrospectionAccessTokenSuccessResponse response = super.createIntrospectionValidResponse(accessTokenId, ticket);
        if (ticket != null) {
            Optional.ofNullable(ticket.getService()).ifPresent(service -> {
                OidcRegisteredService registeredService = (OidcRegisteredService)((OidcConfigurationContext)this.getConfigurationContext()).getServicesManager().findServiceBy(service, OidcRegisteredService.class);
                response.setIss(((OidcConfigurationContext)this.getConfigurationContext()).getIssuerService().determineIssuer(Optional.ofNullable(registeredService)));
            });
            FunctionUtils.doIf((boolean)response.isActive(), o -> response.setScope(String.join((CharSequence)" ", ticket.getScopes()))).accept(response);
            CollectionUtils.firstElement(ticket.getAuthentication().getAttributes().get("DPoPConfirmation")).ifPresent(dpop -> response.setDPopConfirmation(new OAuth20IntrospectionAccessTokenSuccessResponse.DPopConfirmation(dpop.toString())));
        }
        return response;
    }
}

