/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.util.Arrays;
import java.util.Comparator;
import org.passay.dictionary.AbstractWordList;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraySorter;

public class ArrayWordList
extends AbstractWordList {
    protected String[] words;

    public ArrayWordList(String[] array) {
        this(array, true);
    }

    public ArrayWordList(String[] array, boolean caseSensitive) {
        this(array, caseSensitive, null);
    }

    public ArrayWordList(String[] array, boolean caseSensitive, ArraySorter sorter) {
        if (array == null) {
            throw new IllegalArgumentException("Array cannot be null.");
        }
        Comparator<String> comparator = this.comparator = caseSensitive ? WordLists.CASE_SENSITIVE_COMPARATOR : WordLists.CASE_INSENSITIVE_COMPARATOR;
        if (sorter != null) {
            sorter.sort(array, this.comparator);
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) {
                throw new IllegalArgumentException(Arrays.toString(array) + " cannot contain null entry at index " + i);
            }
            if (i <= 0 || this.comparator.compare(array[i], array[i - 1]) >= 0) continue;
            throw new IllegalArgumentException(Arrays.toString(array) + " sorted by " + sorter + " is not correct for " + this.comparator + " at index " + i);
        }
        this.words = array;
    }

    @Override
    public String get(int index) {
        this.checkRange(index);
        return this.words[index];
    }

    @Override
    public int size() {
        return this.words.length;
    }

    public String toString() {
        return String.format("%s@%h::size=%s", this.getClass().getName(), this.hashCode(), this.words.length);
    }
}

