/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.editor.language.json.converter.BaseBpmnJsonConverter;
import org.flowable.editor.language.json.converter.BpmnJsonConverterContext;
import org.flowable.editor.language.json.converter.util.JsonConverterUtil;

public class DecisionTaskJsonConverter
extends BaseBpmnJsonConverter {
    protected static final String REFERENCE_TYPE_DECISION_TABLE = "decisionTable";
    protected static final String REFERENCE_TYPE_DECISION_SERVICE = "decisionService";

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        DecisionTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        DecisionTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("DecisionTask", DecisionTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "DecisionTask";
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap, BpmnJsonConverterContext converterContext) {
        JsonNode decisionServiceReferenceNode;
        ServiceTask serviceTask = new ServiceTask();
        serviceTask.setType("dmn");
        String decisionModelKey = null;
        String referenceType = null;
        JsonNode decisionTableReferenceNode = this.getProperty("decisiontaskdecisiontablereference", elementNode);
        if (decisionTableReferenceNode != null && decisionTableReferenceNode.has("id") && !decisionTableReferenceNode.get("id").isNull()) {
            String decisionTableId = decisionTableReferenceNode.get("id").asText();
            decisionModelKey = converterContext.getDecisionTableModelKeyForDecisionTableModelId(decisionTableId);
            referenceType = REFERENCE_TYPE_DECISION_TABLE;
        }
        if ((decisionServiceReferenceNode = this.getProperty("decisiontaskdecisionservicereference", elementNode)) != null && decisionServiceReferenceNode.has("id") && !decisionServiceReferenceNode.get("id").isNull()) {
            String decisionServiceId = decisionServiceReferenceNode.get("id").asText();
            decisionModelKey = converterContext.getDecisionServiceModelKeyForDecisionServiceModelId(decisionServiceId);
            referenceType = REFERENCE_TYPE_DECISION_SERVICE;
        }
        if (decisionModelKey != null) {
            FieldExtension decisionTableKeyField = new FieldExtension();
            decisionTableKeyField.setFieldName("decisionTableReferenceKey");
            decisionTableKeyField.setStringValue(decisionModelKey);
            serviceTask.getFieldExtensions().add(decisionTableKeyField);
            referenceType = REFERENCE_TYPE_DECISION_SERVICE;
        }
        this.addFlowableExtensionElementWithValue("decisionReferenceType", referenceType, (FlowElement)serviceTask);
        this.addBooleanField(elementNode, serviceTask, "decisiontaskthrowerroronnohits", "decisionTaskThrowErrorOnNoHits");
        this.addBooleanField(elementNode, serviceTask, "decisiontaskfallbacktodefaulttenant", "fallbackToDefaultTenant");
        this.addBooleanField(elementNode, serviceTask, "decisiontasksamedeployment", "sameDeployment");
        return serviceTask;
    }

    protected void addBooleanField(JsonNode elementNode, ServiceTask decisionTask, String propertyName, String fieldName) {
        boolean decisionTableThrowErrorOnNoHitsNode = JsonConverterUtil.getPropertyValueAsBoolean(propertyName, elementNode);
        FieldExtension decisionTableThrowErrorOnNoHitsField = new FieldExtension();
        decisionTableThrowErrorOnNoHitsField.setFieldName(fieldName);
        decisionTableThrowErrorOnNoHitsField.setStringValue(decisionTableThrowErrorOnNoHitsNode ? "true" : "false");
        decisionTask.getFieldExtensions().add(decisionTableThrowErrorOnNoHitsField);
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement, BpmnJsonConverterContext converterContext) {
    }
}

