/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.scripting.ScriptTrace;

public class FlowableScriptEvaluationException
extends FlowableException {
    protected ScriptTrace errorTrace;

    public FlowableScriptEvaluationException(ScriptTrace errorTrace, Throwable cause) {
        super(FlowableScriptEvaluationException.createErrorMessage(errorTrace), cause);
        this.errorTrace = errorTrace;
    }

    protected static String createErrorMessage(ScriptTrace trace) {
        StringBuilder b = new StringBuilder();
        Map<String, String> traceTags = trace.getTraceTags();
        b.append(trace.getRequest().getLanguage());
        b.append(" script evaluation failed: ");
        if (trace.getException() != null && trace.getException().getMessage() != null) {
            String message = trace.getException().getMessage();
            b.append("'").append(message).append("'");
        }
        if (!traceTags.isEmpty()) {
            b.append(" Trace: ");
            b.append(traceTags.entrySet().stream().map(k -> (String)k.getKey() + "=" + (String)k.getValue()).collect(Collectors.joining(", ")));
        }
        return b.toString();
    }

    public ScriptTrace getErrorTrace() {
        return this.errorTrace;
    }
}

