/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.UniqueTicketIdGeneratorConfigurer;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.TicketRegistry})
@Configuration(value="CasCoreTicketIdGeneratorsConfiguration", proxyBeanMethods=false)
class CasCoreTicketIdGeneratorsConfiguration {
    CasCoreTicketIdGeneratorsConfiguration() {
    }

    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"uniqueIdGeneratorsMap"})
    public Map<String, UniqueTicketIdGenerator> uniqueIdGeneratorsMap(List<UniqueTicketIdGeneratorConfigurer> configurers) {
        HashMap<String, UniqueTicketIdGenerator> map = new HashMap<String, UniqueTicketIdGenerator>();
        configurers.forEach(cfg -> {
            Collection pair = cfg.buildUniqueTicketIdGenerators();
            pair.forEach(p -> map.put((String)p.getKey(), (UniqueTicketIdGenerator)p.getValue()));
        });
        return map;
    }
}

