/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20TokenHashGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenHashGenerator.class);
    private final String token;
    private final String algorithm;
    private final RegisteredService registeredService;

    public String generate() {
        byte[] tokenBytes = this.token.getBytes(StandardCharsets.UTF_8);
        if ("none".equalsIgnoreCase(this.algorithm)) {
            LOGGER.debug("Signing algorithm specified by service [{}] is unspecified/none", (Object)this.registeredService.getServiceId());
            return EncodingUtils.encodeUrlSafeBase64((byte[])tokenBytes);
        }
        String alg = this.determineSigningHashAlgorithm();
        LOGGER.debug("Digesting access token hash via algorithm [{}]", (Object)alg);
        byte[] digested = DigestUtils.rawDigest((String)alg, (byte[])tokenBytes);
        byte[] hashBytesLeftHalf = Arrays.copyOf(digested, digested.length / 2);
        return EncodingUtils.encodeUrlSafeBase64((byte[])hashBytesLeftHalf);
    }

    protected String determineSigningHashAlgorithm() {
        LOGGER.debug("Signing algorithm specified is [{}]", (Object)this.algorithm);
        if ("HS512".equalsIgnoreCase(this.algorithm) || "RS512".equalsIgnoreCase(this.algorithm) || "PS512".equalsIgnoreCase(this.algorithm) || "ES512".equalsIgnoreCase(this.algorithm)) {
            return "SHA-512";
        }
        if ("HS384".equalsIgnoreCase(this.algorithm) || "RS384".equalsIgnoreCase(this.algorithm) || "PS384".equalsIgnoreCase(this.algorithm) || "ES384".equalsIgnoreCase(this.algorithm)) {
            return "SHA-384";
        }
        if ("HS256".equalsIgnoreCase(this.algorithm) || "RS256".equalsIgnoreCase(this.algorithm) || "PS256".equalsIgnoreCase(this.algorithm) || "ES256".equalsIgnoreCase(this.algorithm)) {
            return "SHA-256";
        }
        throw new IllegalArgumentException("Could not determine the hash algorithm for token");
    }

    @Generated
    protected OAuth20TokenHashGenerator(OAuth20TokenHashGeneratorBuilder<?, ?> b) {
        this.token = b.token;
        this.algorithm = b.algorithm;
        this.registeredService = b.registeredService;
    }

    @Generated
    public static OAuth20TokenHashGeneratorBuilder<?, ?> builder() {
        return new OAuth20TokenHashGeneratorBuilderImpl();
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public RegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public static abstract class OAuth20TokenHashGeneratorBuilder<C extends OAuth20TokenHashGenerator, B extends OAuth20TokenHashGeneratorBuilder<C, B>> {
        @Generated
        private String token;
        @Generated
        private String algorithm;
        @Generated
        private RegisteredService registeredService;

        @Generated
        public B token(String token) {
            this.token = token;
            return this.self();
        }

        @Generated
        public B algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this.self();
        }

        @Generated
        public B registeredService(RegisteredService registeredService) {
            this.registeredService = registeredService;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "OAuth20TokenHashGenerator.OAuth20TokenHashGeneratorBuilder(token=" + this.token + ", algorithm=" + this.algorithm + ", registeredService=" + String.valueOf(this.registeredService) + ")";
        }
    }

    @Generated
    private static final class OAuth20TokenHashGeneratorBuilderImpl
    extends OAuth20TokenHashGeneratorBuilder<OAuth20TokenHashGenerator, OAuth20TokenHashGeneratorBuilderImpl> {
        @Generated
        private OAuth20TokenHashGeneratorBuilderImpl() {
        }

        @Override
        @Generated
        protected OAuth20TokenHashGeneratorBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public OAuth20TokenHashGenerator build() {
            return new OAuth20TokenHashGenerator(this);
        }
    }
}

