/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20TokenExchangeTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenDecodableCipher;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncodableCipher;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.crypto.DecodableCipher;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuth20JwtAccessTokenEncoder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenEncoder.class);

    public static DecodableCipher<String, String> toDecodableCipher(JwtBuilder accessTokenJwtBuilder, RegisteredService registeredService) {
        return new OAuth20JwtAccessTokenDecodableCipher(registeredService, accessTokenJwtBuilder);
    }

    public static DecodableCipher<String, String> toDecodableCipher(JwtBuilder accessTokenJwtBuilder) {
        return OAuth20JwtAccessTokenEncoder.toDecodableCipher(accessTokenJwtBuilder, null);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuth20AccessTokenResponseResult tokenResult, OAuth20Token token, String issuer) {
        OAuth20JwtAccessTokenEncodableCipher cipher = new OAuth20JwtAccessTokenEncodableCipher(configurationContext, tokenResult.getRegisteredService(), token, tokenResult.getService(), issuer, tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT);
        if (tokenResult.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE && tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT) {
            String audience = Optional.ofNullable(tokenResult.getTokenExchangeAudience()).or(() -> Optional.ofNullable(tokenResult.getTokenExchangeResource()).map(Service::getId)).orElse("");
            cipher.setTokenAudience(audience);
        }
        return cipher;
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20AccessToken accessToken, String issuer) {
        return new OAuth20JwtAccessTokenEncodableCipher(configurationContext, registeredService, (OAuth20Token)accessToken, accessToken.getService(), issuer, false);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuthRegisteredService registeredService, OAuth20AccessToken accessToken) {
        return OAuth20JwtAccessTokenEncoder.toEncodableCipher(configurationContext, (RegisteredService)registeredService, accessToken, configurationContext.getCasProperties().getServer().getPrefix());
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20Token token, Service service, boolean forceEncodeAsJwt) {
        return new OAuth20JwtAccessTokenEncodableCipher(configurationContext, registeredService, token, service, configurationContext.getCasProperties().getServer().getPrefix(), forceEncodeAsJwt);
    }

    public static EncodableCipher<String, String> toEncodableCipher(OAuth20ConfigurationContext configurationContext, OAuth20AccessTokenResponseResult tokenResult, OAuth20Token token) {
        OAuth20JwtAccessTokenEncodableCipher cipher = new OAuth20JwtAccessTokenEncodableCipher(configurationContext, tokenResult.getRegisteredService(), token, tokenResult.getService(), configurationContext.getCasProperties().getServer().getPrefix(), tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT);
        if (tokenResult.getGrantType() == OAuth20GrantTypes.TOKEN_EXCHANGE && tokenResult.getRequestedTokenType() == OAuth20TokenExchangeTypes.JWT) {
            String audience = Optional.ofNullable(tokenResult.getTokenExchangeAudience()).or(() -> Optional.ofNullable(tokenResult.getTokenExchangeResource()).map(Service::getId)).orElse("");
            cipher.setTokenAudience(audience);
        }
        return cipher;
    }

    @Generated
    private OAuth20JwtAccessTokenEncoder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

