/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Set;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.BaseConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectIdentification;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public final class ConnectorObject
extends BaseConnectorObject {
    public ConnectorObject(ObjectClass objectClass, Set<? extends Attribute> attributes) {
        super(objectClass, attributes);
        if (objectClass == null) {
            throw new IllegalArgumentException("ObjectClass may not be null");
        }
        if (!this.attributeMap.containsKey(Uid.NAME)) {
            throw new IllegalArgumentException("The Attribute set must contain a 'Uid'.");
        }
        if (!this.attributeMap.containsKey(Name.NAME)) {
            throw new IllegalArgumentException("The Attribute set must contain a 'Name'.");
        }
    }

    public Uid getUid() {
        Attribute uid = (Attribute)this.attributeMap.get(Uid.NAME);
        if (uid instanceof Uid) {
            return (Uid)uid;
        }
        throw new IllegalArgumentException("__UID__ attribute must be instance of Uid");
    }

    public Name getName() {
        Attribute name = (Attribute)this.attributeMap.get(Name.NAME);
        if (name instanceof Name) {
            return (Name)name;
        }
        throw new IllegalArgumentException("__NAME__ attribute must be instance of Name");
    }

    @Override
    public ConnectorObjectIdentification getIdentification() {
        return new ConnectorObjectIdentification(this.getObjectClass(), Set.of(this.getUid(), this.getName()));
    }

    @Override
    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Uid", this.getUid());
        map.put("ObjectClass", this.getObjectClass());
        map.put("Name", this.getName());
        map.put("Attributes", this.getAttributes());
        return ((Object)map).toString();
    }
}

