/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ConnIdBundle;
import org.apache.syncope.common.lib.to.ConnIdObjectClass;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Connectors")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="connectors")
public interface ConnectorService
extends JAXRSService {
    @GET
    @Path(value="bundles")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnIdBundle> getBundles(@QueryParam(value="lang") String var1);

    @Parameter(name="key", description="Connector instance's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @POST
    @Path(value="{key}/supportedObjectClasses")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnIdObjectClass> buildObjectClassInfo(@NotNull ConnInstanceTO var1, @QueryParam(value="includeSpecial") @DefaultValue(value="false") boolean var2);

    @GET
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ConnInstanceTO read(@NotNull @PathParam(value="key") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Path(value="byResource/{resourceName}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ConnInstanceTO readByResource(@NotNull @PathParam(value="resourceName") String var1, @QueryParam(value="lang") String var2);

    @GET
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ConnInstanceTO> list(@QueryParam(value="lang") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="201", description="ConnInstance successfully created", headers={@Header(name="X-Syncope-Key", schema=@Schema(type="string"), description="UUID generated for the entity created"), @Header(name="Location", schema=@Schema(type="string"), description="URL of the entity created")})})
    @POST
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull ConnInstanceTO var1);

    @Parameter(name="key", description="Connector instance's key", in=ParameterIn.PATH, schema=@Schema(type="string"))
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @PUT
    @Path(value="{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void update(@NotNull ConnInstanceTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @DELETE
    @Path(value="{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void delete(@NotNull @PathParam(value="key") String var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="check")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void check(@NotNull ConnInstanceTO var1);

    @ApiResponses(value={@ApiResponse(responseCode="204", description="Operation was successful")})
    @POST
    @Path(value="reload")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public void reload();
}

