/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.oidc.util.OidcRequestSupport;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.apereo.cas.support.oauth.web.response.OAuth20DefaultCasClientRedirectActionBuilder;
import org.pac4j.cas.client.CasClient;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.exception.http.RedirectionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcCasClientRedirectActionBuilder
extends OAuth20DefaultCasClientRedirectActionBuilder {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcCasClientRedirectActionBuilder.class);
    private final OidcRequestSupport oidcRequestSupport;
    private final OAuth20RequestParameterResolver parameterResolver;

    public Optional<RedirectionAction> build(CasClient casClient, WebContext context) {
        boolean renew = casClient.getConfiguration().isRenew();
        boolean gateway = casClient.getConfiguration().isGateway();
        Set prompts = this.parameterResolver.resolveSupportedPromptValues(context);
        if (prompts.contains("none")) {
            renew = false;
            gateway = true;
        } else if (prompts.contains("login") || this.oidcRequestSupport.isCasAuthenticationOldForMaxAgeAuthorizationRequest(context)) {
            renew = true;
        }
        Optional action = this.build(casClient, context, renew, gateway);
        LOGGER.debug("Final redirect action is [{}]", (Object)action);
        return action;
    }

    @Generated
    public OidcCasClientRedirectActionBuilder(OidcRequestSupport oidcRequestSupport, OAuth20RequestParameterResolver parameterResolver) {
        this.oidcRequestSupport = oidcRequestSupport;
        this.parameterResolver = parameterResolver;
    }
}

