/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server;

import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import javax.net.ssl.KeyManager;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;

public abstract class ConnectorServer {
    private static final String IMPL_NAME = "org.identityconnectors.framework.server.impl.ConnectorServerImpl";
    private int port = 0;
    private int maxConnections = 300;
    private String keyHash;
    private int minWorkers = 10;
    private int maxWorkers = 100;
    private InetAddress ifAddress = null;
    private boolean useSSL = false;
    private List<URL> bundleURLs = null;
    private ClassLoader bundleParentClassLoader;
    private List<KeyManager> keyManagers = CollectionUtil.newReadOnlyList((Object[])new KeyManager[0]);

    public static ConnectorServer newInstance() {
        try {
            Class<?> clazz = Class.forName(IMPL_NAME);
            return (ConnectorServer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private void assertNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("Operation cannot be performed while server is running");
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.assertNotStarted();
        this.port = port;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int max) {
        this.assertNotStarted();
        this.maxConnections = max;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.assertNotStarted();
        this.maxWorkers = maxWorkers;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.assertNotStarted();
        this.minWorkers = minWorkers;
    }

    public InetAddress getIfAddress() {
        return this.ifAddress;
    }

    public void setIfAddress(InetAddress addr) {
        this.assertNotStarted();
        this.ifAddress = addr;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean ssl) {
        this.assertNotStarted();
        this.useSSL = ssl;
    }

    public String getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(String hash) {
        this.assertNotStarted();
        this.keyHash = hash;
    }

    public List<KeyManager> getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(List<KeyManager> keyManagers) {
        this.assertNotStarted();
        this.keyManagers = CollectionUtil.newReadOnlyList(keyManagers);
    }

    public List<URL> getBundleURLs() {
        return this.bundleURLs;
    }

    public void setBundleURLs(List<URL> urls) {
        this.assertNotStarted();
        this.bundleURLs = CollectionUtil.newReadOnlyList(urls);
    }

    public ClassLoader getBundleParentClassLoader() {
        return this.bundleParentClassLoader;
    }

    public void setBundleParentClassLoader(ClassLoader bundleParentClassLoader) {
        this.bundleParentClassLoader = bundleParentClassLoader;
    }

    public abstract Long getStartTime();

    public abstract void start();

    public abstract void stop();

    public abstract boolean isStarted();

    public abstract void awaitStop() throws InterruptedException;
}

