/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.annotationscan;

import com.giffing.wicket.spring.boot.context.extensions.ApplicationInitExtension;
import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.stuff.annotationscan.AnnotatedMountScannerProperties;
import java.util.ArrayList;
import org.apache.wicket.protocol.http.WebApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.annotation.Order;
import org.wicketstuff.annotation.scan.AnnotatedMountScanner;

@ApplicationInitExtension
@ConditionalOnProperty(prefix="wicket.stuff.annotationscan", value={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={AnnotatedMountScanner.class})
@EnableConfigurationProperties(value={AnnotatedMountScannerProperties.class})
@Order(value=1073741873)
public class AnnotatedMountScannerConfig
implements WicketApplicationInitConfiguration {
    @Autowired
    private AnnotatedMountScannerProperties prop;
    @Autowired
    private WicketClassCandidatesHolder candidates;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    public void init(WebApplication webApplication) {
        ArrayList<String> packagesToScan = new ArrayList<String>();
        AnnotatedMountScanner annotatedMountScanner = new AnnotatedMountScanner();
        String packagename = webApplication.getClass().getPackage().getName();
        if (this.prop.getPackagename() != null) {
            packagename = this.prop.getPackagename();
        }
        packagesToScan.add(packagename);
        annotatedMountScanner.scanPackage(packagename).mount(webApplication);
        if (this.candidates.getBasePackages().size() > 0) {
            packagesToScan.addAll(this.candidates.getBasePackages());
            for (String basePackage : this.candidates.getBasePackages()) {
                annotatedMountScanner.scanPackage(basePackage).mount(webApplication);
            }
        }
        this.wicketEndpointRepository.add(new WicketAutoConfig.Builder(this.getClass()).withDetail("properties", (Object)this.prop).withDetail("packagesToScan", packagesToScan).build());
    }
}

