/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.index.disk;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.disk.DiskIndex;
import com.googlecode.cqengine.index.sqlite.support.DBUtils;
import com.googlecode.cqengine.index.support.PartialSortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.SortedKeyStatisticsAttributeIndex;
import com.googlecode.cqengine.index.support.indextype.DiskTypeIndex;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.Query;

public class PartialDiskIndex<A extends Comparable<A>, O>
extends PartialSortedKeyStatisticsAttributeIndex<A, O>
implements DiskTypeIndex {
    final String tableNameSuffix;

    protected PartialDiskIndex(Attribute<O, A> attribute, Query<O> filterQuery) {
        super(attribute, filterQuery);
        this.tableNameSuffix = "_partial_" + DBUtils.sanitizeForTableName(filterQuery.toString());
    }

    @Override
    protected SortedKeyStatisticsAttributeIndex<A, O> createBackingIndex() {
        return new DiskIndex(DiskPersistence.class, this.attribute, this.tableNameSuffix){

            @Override
            public Index getEffectiveIndex() {
                return PartialDiskIndex.this.getEffectiveIndex();
            }
        };
    }

    public static <A extends Comparable<A>, O> PartialDiskIndex<A, O> onAttributeWithFilterQuery(Attribute<O, A> attribute, Query<O> filterQuery) {
        return new PartialDiskIndex<A, O>(attribute, filterQuery);
    }
}

