/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.passwordless;

import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.api.PasswordlessAuthenticationPreProcessor;
import org.apereo.cas.api.PasswordlessUserAccount;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialTrait;
import org.apereo.cas.authentication.MutableCredential;
import org.apereo.cas.authentication.SurrogateAuthenticationPrincipalBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.surrogate.SurrogateAuthenticationService;
import org.apereo.cas.authentication.surrogate.SurrogateCredentialTrait;
import org.apereo.cas.impl.token.PasswordlessAuthenticationToken;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurrogatePasswordlessAuthenticationPreProcessor
implements PasswordlessAuthenticationPreProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SurrogatePasswordlessAuthenticationPreProcessor.class);
    private final ServicesManager servicesManager;
    private final SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder;
    private final SurrogateAuthenticationService surrogateAuthenticationService;

    public AuthenticationResultBuilder process(AuthenticationResultBuilder resultBuilder, PasswordlessUserAccount passwordlessUserAccount, Service service, Credential credential, PasswordlessAuthenticationToken token) throws Throwable {
        LOGGER.debug("Evaluating passwordless authentication token [{}] issued for [{}]", (Object)token, (Object)passwordlessUserAccount);
        if (token.getProperties().containsKey("surrogateUsername") && credential instanceof MutableCredential) {
            MutableCredential mutableCredential = (MutableCredential)credential;
            String surrogateUsername = (String)token.getProperties().get("surrogateUsername");
            Principal principal = resultBuilder.getInitialAuthentication().map(Authentication::getPrincipal).orElseThrow();
            LOGGER.debug("Evaluating principal [{}] authorization to impersonate [{}]", (Object)principal, (Object)surrogateUsername);
            if (this.surrogateAuthenticationService.canImpersonate(surrogateUsername, principal, Optional.ofNullable(service))) {
                mutableCredential.getCredentialMetadata().addTrait((CredentialTrait)new SurrogateCredentialTrait(surrogateUsername));
                RegisteredService registeredService = this.servicesManager.findServiceBy(service);
                LOGGER.debug("Principal [{}] is authorized to impersonate [{}]", (Object)principal, (Object)surrogateUsername);
                return this.surrogatePrincipalBuilder.buildSurrogateAuthenticationResult(resultBuilder, (Credential)mutableCredential, registeredService).orElse(resultBuilder);
            }
        }
        return resultBuilder;
    }

    @Generated
    public SurrogatePasswordlessAuthenticationPreProcessor(ServicesManager servicesManager, SurrogateAuthenticationPrincipalBuilder surrogatePrincipalBuilder, SurrogateAuthenticationService surrogateAuthenticationService) {
        this.servicesManager = servicesManager;
        this.surrogatePrincipalBuilder = surrogatePrincipalBuilder;
        this.surrogateAuthenticationService = surrogateAuthenticationService;
    }
}

