/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.utils.URIUtils;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConfigurationProperties;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.api.RemoteFrameworkConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnIdBundleManager
implements ConnIdBundleManager {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnIdBundleManager.class);
    protected final List<URI> locations;
    protected final Map<URI, ConnectorInfoManager> connInfoManagers = Collections.synchronizedMap(new LinkedHashMap());

    public DefaultConnIdBundleManager(List<String> stringLocations) {
        this.locations = new ArrayList<URI>();
        stringLocations.forEach(location -> {
            try {
                this.locations.add(URIUtils.buildForConnId((String)location));
                LOG.info("Valid ConnId location: {}", (Object)location.trim());
            }
            catch (Exception e) {
                LOG.error("Invalid ConnId location: {}", (Object)location.trim(), (Object)e);
            }
        });
    }

    public List<URI> getLocations() {
        return this.locations;
    }

    protected void initLocal(URI location) {
        File bundleDirectory = Path.of(location).toFile();
        String[] bundleFiles = bundleDirectory.list();
        if (bundleFiles == null) {
            throw new NotFoundException("Local bundles directory " + String.valueOf(location));
        }
        ArrayList<URL> bundleFileURLs = new ArrayList<URL>();
        for (String file : bundleFiles) {
            try {
                bundleFileURLs.add(IOUtil.makeURL((Path)bundleDirectory.toPath(), (String)file));
            }
            catch (IOException ignore) {
                LOG.debug("{}/{} is not a valid connector bundle", new Object[]{bundleDirectory, file, ignore});
            }
        }
        if (bundleFileURLs.isEmpty()) {
            LOG.warn("No connector bundles found in {}", (Object)location);
        }
        LOG.debug("Configuring local connector server:\n\tFiles: {}", bundleFileURLs);
        ConnectorInfoManager manager = ConnectorInfoManagerFactory.getInstance().getLocalManager((URL[])bundleFileURLs.toArray(URL[]::new));
        if (manager == null) {
            throw new NotFoundException("Local ConnectorInfoManager");
        }
        this.connInfoManagers.put(location, manager);
    }

    protected void initRemote(URI location) {
        String[] trustAllCerts;
        String[] params;
        String host = location.getHost();
        int port = location.getPort();
        GuardedString key = new GuardedString(location.getUserInfo().toCharArray());
        boolean useSSL = location.getScheme().equals("connids");
        ArrayList<1> trustManagers = new ArrayList<1>();
        String[] stringArray = params = StringUtils.isBlank((CharSequence)location.getQuery()) ? null : location.getQuery().split("&");
        if (params != null && params.length > 0 && (trustAllCerts = params[0].split("=")).length > 1 && "trustAllCerts".equalsIgnoreCase(trustAllCerts[0]) && "true".equalsIgnoreCase(trustAllCerts[1])) {
            trustManagers.add(new X509TrustManager(this){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            });
        }
        LOG.debug("Configuring remote connector server:\n\tHost: {}\n\tPort: {}\n\tKey: {}\n\tUseSSL: {}\n\tTrustAllCerts: {}", new Object[]{host, port, key, useSSL, !trustManagers.isEmpty()});
        RemoteFrameworkConnectionInfo info = new RemoteFrameworkConnectionInfo(host, port, key, useSSL, trustManagers, 60000);
        LOG.debug("Remote connection info: {}", (Object)info);
        ConnectorInfoManager manager = ConnectorInfoManagerFactory.getInstance().getRemoteManager(info);
        if (manager == null) {
            throw new NotFoundException("Remote ConnectorInfoManager");
        }
        this.connInfoManagers.put(location, manager);
    }

    public void resetConnManagers() {
        this.connInfoManagers.clear();
    }

    public Map<URI, ConnectorInfoManager> getConnManagers() {
        if (this.connInfoManagers.isEmpty()) {
            this.locations.forEach(location -> {
                try {
                    if ("file".equals(location.getScheme())) {
                        LOG.debug("Local initialization: {}", location);
                        this.initLocal((URI)location);
                    } else if (location.getScheme().startsWith("connid")) {
                        LOG.debug("Remote initialization: {}", location);
                        this.initRemote((URI)location);
                    } else {
                        LOG.warn("Unsupported scheme: {}", location);
                    }
                }
                catch (Exception e) {
                    LOG.error("Could not process {}", location, (Object)e);
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            this.connInfoManagers.entrySet().stream().peek(entry -> LOG.debug("Connector bundles found at {}", entry.getKey())).forEach(entry -> ((ConnectorInfoManager)entry.getValue()).getConnectorInfos().forEach(connInfo -> LOG.debug("\t{}", (Object)connInfo.getConnectorDisplayName())));
        }
        return this.connInfoManagers;
    }

    public Pair<URI, ConnectorInfo> getConnectorInfo(ConnInstance connInstance) {
        URI uriLocation = null;
        try {
            uriLocation = URIUtils.buildForConnId((String)connInstance.getLocation());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ConnId location " + connInstance.getLocation(), e);
        }
        ConnectorKey key = new ConnectorKey(connInstance.getBundleName(), connInstance.getVersion(), connInstance.getConnectorName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("\nBundle name: {}\nBundle version: {}\nBundle class: {}", new Object[]{key.getBundleName(), key.getBundleVersion(), key.getConnectorName()});
        }
        ConnectorInfo info = null;
        if (this.getConnManagers().containsKey(uriLocation)) {
            info = this.getConnManagers().get(uriLocation).findConnectorInfo(key);
        }
        if (info == null) {
            throw new NotFoundException("ConnectorInfo for location " + connInstance.getLocation() + " and key " + String.valueOf(key));
        }
        return Pair.of((Object)uriLocation, info);
    }

    public Map<URI, ConnectorInfoManager> getConnInfoManagers() {
        return this.connInfoManagers;
    }

    public ConfigurationProperties getConfigurationProperties(ConnectorInfo info) {
        if (info == null) {
            throw new NotFoundException("Invalid: connector info is null");
        }
        APIConfiguration apiConfig = info.createDefaultAPIConfiguration();
        ConfigurationProperties properties = apiConfig.getConfigurationProperties();
        if (properties == null) {
            throw new NotFoundException("Configuration properties");
        }
        if (LOG.isDebugEnabled()) {
            properties.getPropertyNames().forEach(propName -> LOG.debug("Property Name: {}\nProperty Type: {}", (Object)properties.getProperty(propName).getName(), (Object)properties.getProperty(propName).getType()));
        }
        return properties;
    }
}

