/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.syncope.common.lib.report.ReportConf;
import org.apache.syncope.common.lib.types.OpEvent;
import org.apache.syncope.core.persistence.api.dao.ReportDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.Report;
import org.apache.syncope.core.persistence.api.entity.ReportExec;
import org.apache.syncope.core.persistence.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.JobNamer;
import org.apache.syncope.core.provisioning.api.job.report.ReportJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.java.job.report.ReportJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractReportJobDelegate
implements ReportJobDelegate {
    protected static final Logger LOG = LoggerFactory.getLogger(ReportJobDelegate.class);
    @Autowired
    protected SecurityProperties securityProperties;
    protected Report report;
    protected ReportConf conf;
    @Autowired
    protected ReportDAO reportDAO;
    @Autowired
    protected EntityFactory entityFactory;
    @Autowired
    protected NotificationManager notificationManager;
    @Autowired
    protected AuditManager auditManager;
    @Autowired
    protected ApplicationEventPublisher publisher;

    public void setConf(ReportConf conf) {
        this.conf = conf;
    }

    protected void setStatus(String status) {
        this.publisher.publishEvent((ApplicationEvent)new JobStatusEvent((Object)this, AuthContextUtils.getDomain(), JobNamer.getJobName((Report)this.report), status));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void execute(String reportKey, JobExecutionContext context) throws JobExecutionException {
        OpEvent.Outcome result;
        this.report = (Report)this.reportDAO.findById(reportKey).orElseThrow(() -> new JobExecutionException("Report " + reportKey + " not found"));
        if (!this.report.isActive()) {
            LOG.info("Report {} not active, aborting...", (Object)reportKey);
            return;
        }
        String executor = Optional.ofNullable(context.getExecutor()).orElseGet(() -> this.securityProperties.getAdminUser());
        ReportExec execution = (ReportExec)this.entityFactory.newEntity(ReportExec.class);
        execution.setStart(OffsetDateTime.now());
        execution.setReport(this.report);
        execution.setExecutor(executor);
        this.setStatus("Initialization completed");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(baos);
        zos.setLevel(9);
        try {
            zos.putNextEntry(new ZipEntry(this.report.getName()));
        }
        catch (IOException e) {
            throw new JobExecutionException("While configuring for output", (Throwable)e);
        }
        this.setStatus("Starting");
        try {
            execution.setMessage(this.doExecute(zos, context));
            execution.setStatus(ReportJob.Status.SUCCESS.name());
            result = OpEvent.Outcome.SUCCESS;
        }
        catch (JobExecutionException e) {
            LOG.error("While executing report {}", (Object)reportKey, (Object)e);
            result = OpEvent.Outcome.FAILURE;
            execution.setMessage(ExceptionUtils2.getFullStackTrace((Throwable)e));
            execution.setStatus(ReportJob.Status.FAILURE.name());
        }
        finally {
            try {
                zos.closeEntry();
                zos.close();
            }
            catch (IOException e) {
                LOG.error("While closing output", (Throwable)e);
            }
        }
        if (result == OpEvent.Outcome.SUCCESS) {
            execution.setExecResult(baos.toByteArray());
        }
        execution.setEnd(OffsetDateTime.now());
        this.report.add(execution);
        this.report = (Report)this.reportDAO.save((Entity)this.report);
        this.notificationManager.createTasks(executor, OpEvent.CategoryType.REPORT, this.getClass().getSimpleName(), null, this.getClass().getSimpleName(), result, (Object)this.report, (Object)execution, new Object[0]);
        this.auditManager.audit(AuthContextUtils.getDomain(), executor, OpEvent.CategoryType.REPORT, this.report.getClass().getSimpleName(), null, null, result, (Object)this.report, null, new Object[0]);
    }

    protected abstract String doExecute(OutputStream var1, JobExecutionContext var2) throws JobExecutionException;
}

