/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.api.attrvalue;

import jakarta.validation.ConstraintViolation;
import jakarta.validation.ValidationException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.EntityViolationType;

public class InvalidEntityException
extends ValidationException {
    private static final long serialVersionUID = 3249297275444409691L;
    private final String entityClassSimpleName;
    private final Map<Class<?>, Set<EntityViolationType>> violations = new HashMap();

    public InvalidEntityException(Class<?> entityClass, EntityViolationType entityViolationType, String message) {
        this.entityClassSimpleName = entityClass.getSimpleName();
        entityViolationType.setMessage(Optional.ofNullable(message).map(String::trim).orElse(""));
        this.violations.put(entityClass, EnumSet.noneOf(EntityViolationType.class));
        this.violations.get(entityClass).add(entityViolationType);
    }

    public InvalidEntityException(String entityClassSimpleName, Set<ConstraintViolation<Object>> violations) {
        this.entityClassSimpleName = entityClassSimpleName;
        violations.forEach(violation -> {
            EntityViolationType entityViolationType;
            String key = StringUtils.substringBefore((String)violation.getMessageTemplate(), (String)";").trim();
            String message = StringUtils.substringAfter((String)violation.getMessageTemplate(), (String)";").trim();
            try {
                entityViolationType = EntityViolationType.valueOf((String)key);
            }
            catch (IllegalArgumentException e) {
                entityViolationType = EntityViolationType.Standard;
            }
            entityViolationType.setMessage(message);
            entityViolationType.setPropertyPath(violation.getPropertyPath().toString());
            entityViolationType.setInvalidValue(violation.getInvalidValue());
            if (!this.violations.containsKey(violation.getLeafBean().getClass())) {
                this.violations.put(violation.getLeafBean().getClass(), EnumSet.noneOf(EntityViolationType.class));
            }
            this.violations.get(violation.getLeafBean().getClass()).add(entityViolationType);
        });
    }

    public final boolean hasViolation(EntityViolationType type) {
        return this.violations.keySet().stream().anyMatch(entity -> this.violations.get(entity).contains(type));
    }

    public String getEntityClassSimpleName() {
        return this.entityClassSimpleName;
    }

    public final Map<Class<?>, Set<EntityViolationType>> getViolations() {
        return this.violations;
    }

    public String getMessage() {
        return this.violations.entrySet().stream().map(entry -> ((Class)entry.getKey()).getSimpleName() + " " + ((Set)entry.getValue()).toString()).collect(Collectors.joining(","));
    }
}

