/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.ldap;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.cas.authentication.principal.BaseDelegatedClientAuthenticationCredentialResolver;
import org.apereo.cas.authentication.principal.ClientCredential;
import org.apereo.cas.authentication.principal.DelegatedAuthenticationCandidateProfile;
import org.apereo.cas.configuration.model.support.ldap.AbstractLdapProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationLdapProfileSelectionProperties;
import org.apereo.cas.util.LdapConnectionFactory;
import org.apereo.cas.util.LdapUtils;
import org.apereo.cas.web.flow.DelegatedClientAuthenticationConfigurationContext;
import org.jooq.lambda.Unchecked;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapAttribute;
import org.ldaptive.SearchResponse;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class LdapDelegatedClientAuthenticationCredentialResolver
extends BaseDelegatedClientAuthenticationCredentialResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapDelegatedClientAuthenticationCredentialResolver.class);

    public LdapDelegatedClientAuthenticationCredentialResolver(DelegatedClientAuthenticationConfigurationContext configContext) {
        super(configContext);
    }

    public List<DelegatedAuthenticationCandidateProfile> resolve(RequestContext context, ClientCredential credentials) {
        UserProfile profile = this.resolveUserProfile(context, credentials).orElseThrow();
        List ldapServers = this.configContext.getCasProperties().getAuthn().getPac4j().getProfileSelection().getLdap();
        return ldapServers.stream().map(Unchecked.function(props -> this.queryLdap((Pac4jDelegatedAuthenticationLdapProfileSelectionProperties)props, profile))).flatMap(Collection::stream).collect(Collectors.toList());
    }

    protected List<DelegatedAuthenticationCandidateProfile> queryLdap(Pac4jDelegatedAuthenticationLdapProfileSelectionProperties ldap, UserProfile profile) throws Exception {
        ConnectionFactory connectionFactory = LdapUtils.newLdaptiveConnectionFactory((AbstractLdapProperties)ldap);
        LOGGER.debug("Configured LDAP delegated authentication profile selection via [{}]", (Object)ldap.getLdapUrl());
        try (LdapConnectionFactory factory = new LdapConnectionFactory(connectionFactory);){
            FilterTemplate filter = LdapUtils.newLdaptiveSearchFilter((String)ldap.getSearchFilter(), (String)"user", List.of(profile.getId()));
            LOGGER.debug("Fetching user attributes [{}] for [{}] via [{}]", new Object[]{ldap.getAttributes(), profile, filter});
            SearchResponse result = factory.executeSearchOperation(ldap.getBaseDn(), filter, 0, ldap.getAttributes().toArray(ArrayUtils.EMPTY_STRING_ARRAY));
            LOGGER.debug("Found entries: [{}]", (Object)result.getEntries().size());
            List<DelegatedAuthenticationCandidateProfile> list = result.getEntries().stream().map(entry -> {
                LOGGER.trace("Found entry [{}]", entry);
                HashMap<String, Collection> attributes = new HashMap<String, Collection>(profile.getAttributes());
                for (LdapAttribute attr : entry.getAttributes()) {
                    attributes.put(attr.getName(), attr.getStringValues());
                }
                String name = Optional.ofNullable(entry.getAttribute(ldap.getProfileIdAttribute())).map(LdapAttribute::getStringValue).orElseGet(() -> ((UserProfile)profile).getId());
                LOGGER.debug("Adding attributes [{}] to the selected profile: [{}]", attributes, (Object)name);
                return DelegatedAuthenticationCandidateProfile.builder().attributes(attributes).id(name).key(UUID.randomUUID().toString()).linkedId(profile.getId()).build();
            }).collect(Collectors.toList());
            return list;
        }
    }
}

