/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.xml.ws.WebServiceException;
import java.util.Optional;
import org.apache.commons.lang3.Strings;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncopeUIRequestCycleListener
implements IRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeUIRequestCycleListener.class);

    private static <T extends Exception> Optional<T> instanceOf(Exception e, Class<T> clazz) {
        if (clazz.isAssignableFrom(e.getClass())) {
            return Optional.of(e);
        }
        if (e.getCause() != null && clazz.isAssignableFrom(e.getCause().getClass())) {
            return Optional.of((Exception)e.getCause());
        }
        if (e.getCause() != null && e.getCause().getCause() != null && clazz.isAssignableFrom(e.getCause().getCause().getClass())) {
            return Optional.of((Exception)e.getCause().getCause());
        }
        return Optional.empty();
    }

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        LOG.error("Exception found", (Throwable)e);
        PageParameters parameters = new PageParameters();
        parameters.add("notificationLevel", (Object)"error");
        if (SyncopeUIRequestCycleListener.instanceOf(e, UnauthorizedInstantiationException.class).isPresent()) {
            parameters.add("notificationMessage", (Object)BaseSession.Error.AUTHORIZATION.message());
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, NotAuthorizedException.class).isPresent()) {
            NotAuthorizedException nae = SyncopeUIRequestCycleListener.instanceOf(e, NotAuthorizedException.class).get();
            if (Strings.CI.contains((CharSequence)nae.getMessage(), (CharSequence)"expired")) {
                parameters.add("notificationMessage", (Object)BaseSession.Error.SESSION_EXPIRED.message());
            } else {
                parameters.add("notificationMessage", (Object)BaseSession.Error.AUTHORIZATION.message());
            }
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, SyncopeClientException.class).isPresent()) {
            SyncopeClientException sce = SyncopeUIRequestCycleListener.instanceOf(e, SyncopeClientException.class).get();
            String errorMessage = sce.getType() == ClientExceptionType.Unknown ? String.join((CharSequence)"", sce.getElements()) : sce.getMessage();
            parameters.add("notificationMessage", (Object)errorMessage);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, BadRequestException.class).isPresent() || SyncopeUIRequestCycleListener.instanceOf(e, WebServiceException.class).isPresent()) {
            parameters.add("notificationMessage", (Object)BaseSession.Error.REST.message());
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, PageExpiredException.class).isPresent() || !this.isSignedIn()) {
            parameters.add("notificationMessage", (Object)BaseSession.Error.SESSION_EXPIRED.message());
        } else {
            Optional<ForbiddenException> cause = SyncopeUIRequestCycleListener.instanceOf(e, ForbiddenException.class);
            if (cause.isPresent()) {
                parameters.add("notificationMessage", (Object)cause.get().getMessage());
            } else {
                return new RenderPageRequestHandler((IPageProvider)new PageProvider((IRequestablePage)new ExceptionErrorPage((Throwable)e, null)));
            }
        }
        try {
            this.invalidateSession();
        }
        catch (Throwable t) {
            LOG.debug("Unexpected error while forcing logout after error", t);
        }
        return new RenderPageRequestHandler(this.getErrorPageClass(), parameters);
    }

    protected abstract boolean isSignedIn();

    protected abstract void invalidateSession();

    protected abstract Class<? extends BaseLogin> getErrorPageClass();
}

