/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractSaslTest;
import kafka.api.Both$;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001B\u0015+\u0001=BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004B\u0001\u0001\u0006I!\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0003D\u0011\u0019q\u0005\u0001)A\u0005\t\"9q\n\u0001b\u0001\n#\u0002\u0006B\u00021\u0001A\u0003%\u0011\u000bC\u0004b\u0001\t\u0007I\u0011\u000b2\t\r5\u0004\u0001\u0015!\u0003d\u0011\u001dq\u0007A1A\u0005R\tDaa\u001c\u0001!\u0002\u0013\u0019\u0007b\u00029\u0001\u0005\u0004%\t!\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002:\t\u000fY\u0004!\u0019!C\u0001c\"1q\u000f\u0001Q\u0001\nIDq\u0001\u001f\u0001C\u0002\u0013\u0005\u0011\u000f\u0003\u0004z\u0001\u0001\u0006IA\u001d\u0005\bu\u0002\u0011\r\u0011\"\u00019\u0011\u0019Y\b\u0001)A\u0005s!9A\u0010\u0001b\u0001\n\u0003\t\bBB?\u0001A\u0003%!\u000fC\u0004\u007f\u0001\t\u0007I\u0011A@\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0003Aq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002,\u0001!\t%!\f\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBA-\u0001\u0011\u0005\u00111\f\u0005\b\u0003\u0017\u0003A\u0011AA(\u0011\u001d\t)\n\u0001C\u0001\u0003\u001fBq!!'\u0001\t\u0003\ty\u0005C\u0004\u0002\u001e\u0002!\t!a\u0014\t\u000f\u0005\u0005\u0006\u0001\"\u0003\u0002$\"9\u0011q\u0018\u0001\u0005\u0002\u0005=\u0003bBAb\u0001\u0011%\u0011q\n\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011%\t\t\u000fAI\u0001\n\u0013\t\u0019\u000fC\u0004\u0002z\u0002!I!a?\t\u000f\t\u001d\u0001\u0001\"\u0003\u0003\n!9!Q\u0002\u0001\u0005\n\t=!!J*bg2\u001cE.[3oiN<\u0016\u000e\u001e5J]Z\fG.\u001b3De\u0016$WM\u001c;jC2\u001cH+Z:u\u0015\tYC&A\u0002ba&T\u0011!L\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0007\u0005\u00022e5\t!&\u0003\u00024U\t\u0001\u0012IY:ue\u0006\u001cGoU1tYR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0002\"!\r\u0001\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001:!\tQt(D\u0001<\u0015\taT(\u0001\u0003mC:<'\"\u0001 \u0002\t)\fg/Y\u0005\u0003\u0001n\u0012aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\tA\tE\u0002F\u0019fj\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005%S\u0015AC2pY2,7\r^5p]*\t1*A\u0003tG\u0006d\u0017-\u0003\u0002N\r\n!A*[:u\u0003iY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001R!\t\u0011f,D\u0001T\u0015\t!V+\u0001\u0003bkRD'B\u0001,X\u0003!\u0019XmY;sSRL(B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011QF\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`'\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0012g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\u0013\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001d!\r!WmZ\u0007\u0002\u0015&\u0011aM\u0013\u0002\u0005'>lW\r\u0005\u0002iW6\t\u0011N\u0003\u0002k{\u0005!Q\u000f^5m\u0013\ta\u0017N\u0001\u0006Qe>\u0004XM\u001d;jKN\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm]\u0001\u0016G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:!\u00035\u0019wN\\:v[\u0016\u00148i\\;oiV\t!\u000f\u0005\u0002eg&\u0011AO\u0013\u0002\u0004\u0013:$\u0018AD2p]N,X.\u001a:D_VtG\u000fI\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0002uaV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\t)!D\u0001X\u0013\r\t9a\u0016\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\u0011\ty!!\u0006\u0011\u0007\u0011\f\t\"C\u0002\u0002\u0014)\u0013A!\u00168ji\"9\u0011q\u0003\rA\u0002\u0005e\u0011\u0001\u0003;fgRLeNZ8\u0011\t\u0005m\u0011qE\u0007\u0003\u0003;Q1aKA\u0010\u0015\u0011\t\t#a\t\u0002\u000f),\b/\u001b;fe*\u0019\u0011Q\u0005/\u0002\u000b),h.\u001b;\n\t\u0005%\u0012Q\u0004\u0002\t)\u0016\u001cH/\u00138g_\u0006Y2M]3bi\u0016\u0004&/\u001b<jY\u0016<W\rZ!e[&t7\t\\5f]R$\"!a\f\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u0005)\u0011\rZ7j]*\u0019\u0011\u0011H-\u0002\u000f\rd\u0017.\u001a8ug&!\u0011QHA\u001a\u0005\u0015\tE-\\5o\u0003\u0015\u0019X\r^+q)\u0011\ty!a\u0011\t\u000f\u0005]!\u00041\u0001\u0002\u001a!\u001a!$a\u0012\u0011\t\u0005m\u0011\u0011J\u0005\u0005\u0003\u0017\niB\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003\u001fA3aGA*!\u0011\tY\"!\u0016\n\t\u0005]\u0013Q\u0004\u0002\n\u0003\u001a$XM]#bG\"\fQ\u0005^3tiB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3\u0015\t\u0005=\u0011Q\f\u0005\b\u0003?b\u0002\u0019AA1\u0003QI7/\u00133f[B|G/\u001a8dK\u0016s\u0017M\u00197fIB\u0019A-a\u0019\n\u0007\u0005\u0015$JA\u0004C_>dW-\u00198)\u0007q\tI\u0007\u0005\u0003\u0002l\u0005ETBAA7\u0015\u0011\ty'a\b\u0002\rA\f'/Y7t\u0013\u0011\t\u0019(!\u001c\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH\u000fK\u0004\u001d\u0003o\n\u0019)!\"\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wRA!! \u0002n\u0005A\u0001O]8wS\u0012,'/\u0003\u0003\u0002\u0002\u0006m$a\u0003,bYV,7k\\;sG\u0016\f\u0001BY8pY\u0016\fgn\u001d\u0017\u0005\u0003\u000f\u000bI)G\u0001\u00023\u0005\u0001\u0011A\r;fgR$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007u\ty\t\u0005\u0003\u0002\u001c\u0005E\u0015\u0002BAJ\u0003;\u0011A\u0001V3ti\u0006)C/Z:u\u0007>t7/^7fe^KG\u000f[!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004=\u0005=\u0015!\u000e;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGoQ8ogVlWM],ji\"\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016D3aHAH\u0003-#Xm\u001d;NC:,\u0018\r\\!tg&<g.\\3oi\u000e{gn];nKJ<\u0016\u000e\u001e5BkR|7i\\7nSR$\u0015n]1cY\u0016$w+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\r\u0001\u0013qR\u0001(m\u0016\u0014\u0018NZ=D_:\u001cX/\\3s/&$\b.Q;uQ\u0016tG/[2bi&|gNR1jYV\u0014X\r\u0006\u0003\u0002\u0010\u0005\u0015\u0006bBATC\u0001\u0007\u0011\u0011V\u0001\tG>t7/^7feBA\u00111VAX\u0003g\u000b\u0019,\u0004\u0002\u0002.*!\u0011qUA\u001c\u0013\u0011\t\t,!,\u0003\u0011\r{gn];nKJ\u0004R\u0001ZA[\u0003sK1!a.K\u0005\u0015\t%O]1z!\r!\u00171X\u0005\u0004\u0003{S%\u0001\u0002\"zi\u0016\fQ\u0006^3ti.\u000bgm[1BI6Lgn\u00117jK:$x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:fQ\r\u0011\u0013qR\u0001\u0017GJ,\u0017\r^3DY&,g\u000e^\"sK\u0012,g\u000e^5bY\u0006i1/\u001a8e\u001f:,'+Z2pe\u0012$b!a\u0004\u0002J\u0006]\u0007bBAfI\u0001\u0007\u0011QZ\u0001\taJ|G-^2feBA\u0011qZAj\u0003g\u000b\u0019,\u0004\u0002\u0002R*!\u00111ZA\u001c\u0013\u0011\t).!5\u0003\u001b-\u000bgm[1Qe>$WoY3s\u0011%\tI\u000e\nI\u0001\u0002\u0004\tY.A\u0005nCb<\u0016-\u001b;NgB\u0019A-!8\n\u0007\u0005}'J\u0001\u0003M_:<\u0017aF:f]\u0012|e.\u001a*fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t)O\u000b\u0003\u0002\\\u0006\u001d8FAAu!\u0011\tY/!>\u000e\u0005\u00055(\u0002BAx\u0003c\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M(*\u0001\u0006b]:|G/\u0019;j_:LA!a>\u0002n\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002;Y,'/\u001b4z\u0003V$\b.\u001a8uS\u000e\fG/[8o\u000bb\u001cW\r\u001d;j_:$B!a\u0004\u0002~\"A\u0011q \u0014\u0005\u0002\u0004\u0011\t!\u0001\u0004bGRLwN\u001c\t\u0006I\n\r\u0011qB\u0005\u0004\u0005\u000bQ%\u0001\u0003\u001fcs:\fW.\u001a \u0002\u001fY,'/\u001b4z/&$\bNU3uef$B!a\u0004\u0003\f!A\u0011q`\u0014\u0005\u0002\u0004\u0011\t!A\u000ede\u0016\fG/\u001a+sC:\u001c\u0018m\u0019;j_:\fG\u000e\u0015:pIV\u001cWM\u001d\u000b\u0003\u0003\u001b\u0004")
public class SaslClientsWithInvalidCredentialsTest
extends AbstractSaslTest {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
    private final SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
    private final Some<Properties> serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
    private final Some<Properties> clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
    private final int consumerCount;
    private final int producerCount;
    private final int brokerCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
        super.configureSecurityBeforeServersStart(testInfo);
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    public Admin createPrivilegedAdminClient() {
        return this.createAdminClient(this.bootstrapServers(this.bootstrapServers$default$1()), this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties(), this.kafkaClientSaslMechanism(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp(testInfo);
        this.createTopic(this.topic(), this.numPartitions(), this.brokerCount(), this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testProducerWithAuthenticationFailure(boolean isIdempotenceEnabled) {
        KafkaProducer kafkaProducer;
        Properties prop = new Properties();
        prop.setProperty("enable.idempotence", Boolean.toString(isIdempotenceEnabled));
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        KafkaProducer producer = this.createProducer(x$2, x$3, prop);
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 10000L);
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var9_6 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> producer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs2).toString());
        Object var14_9 = null;
        this.createClientCredential();
        if (isIdempotenceEnabled) {
            ByteArraySerializer x$5 = this.createProducer$default$1();
            ByteArraySerializer x$6 = this.createProducer$default$2();
            kafkaProducer = this.createProducer(x$5, x$6, prop);
        } else {
            kafkaProducer = producer;
        }
        KafkaProducer producer2 = kafkaProducer;
        int n = 0;
        long l = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer2, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
        }
    }

    @Test
    public void testTransactionalProducerWithAuthenticationFailure() {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> txProducer.initTransactions();
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var2_2 = null;
        this.createClientCredential();
        Assertions.assertThrows(KafkaException.class, () -> txProducer.initTransactions());
    }

    @Test
    public void testConsumerWithAuthenticationFailure() {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAuthenticationFailure() {
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure() {
        this.consumerConfig().setProperty("enable.auto.commit", Boolean.toString(false));
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    /*
     * WARNING - void declaration
     */
    private void verifyConsumerWithAuthenticationFailure(Consumer<byte[], byte[]> consumer) {
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> consumer.poll(Duration.ofMillis(1000L));
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
        long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
        Object var3_2 = null;
        JFunction0.mcV.sp & Serializable verifyAuthenticationException_action2 = (JFunction0.mcV.sp & Serializable)() -> consumer.partitionsFor(this.topic());
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action2));
        long verifyAuthenticationException_elapsedMs2 = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
        Assertions.assertTrue((verifyAuthenticationException_elapsedMs2 <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs2).toString());
        Object var8_5 = null;
        this.createClientCredential();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int n = 0;
        long l = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
        }
        int n2 = 0;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_waitTimeMs2 = 15000L;
        long verifyWithRetry_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            void verifyWithRetry_waitUntilTrue_pause;
            boolean bl;
            try {
                ++n2;
                SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$4(consumer);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime2 + verifyWithRetry_waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n2).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs2), (long)verifyWithRetry_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testKafkaAdminClientWithAuthenticationFailure() {
        Properties props = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties());
        props.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        try (Admin adminClient = Admin.create((Properties)props);){
            JFunction0.mcV.sp & Serializable verifyAuthenticationException_action = (JFunction0.mcV.sp & Serializable)() -> this.describeTopic$1(adminClient);
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            Assertions.assertThrows(Exception.class, () -> SaslClientsWithInvalidCredentialsTest.$anonfun$verifyAuthenticationException$1((Function0)verifyAuthenticationException_action));
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assertions.assertTrue((verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString());
            Object var4_3 = null;
            this.createClientCredential();
            int n = 0;
            long l = 100L;
            long verifyWithRetry_waitUntilTrue_waitTimeMs = 15000L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    this.describeTopic$1(adminClient);
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (!bl) {
                    void verifyWithRetry_waitUntilTrue_pause;
                    if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + verifyWithRetry_waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(verifyWithRetry_waitUntilTrue_waitTimeMs), (long)verifyWithRetry_waitUntilTrue_pause));
                    continue;
                }
                break;
            }
        }
    }

    private void createClientCredential() {
        this.createScramCredentialsViaPrivilegedAdminClient(JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    private void sendOneRecord(KafkaProducer<byte[], byte[]> producer, long maxWaitMs) {
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Predef$.MODULE$.int2Integer(this.tp().partition()), Predef$.MODULE$.long2Long(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assertions.assertTrue((recordMetadata.offset() >= 0L ? 1 : 0) != 0, (String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private long sendOneRecord$default$2() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        Assertions.assertThrows(Exception.class, () -> action.apply$mcV$sp());
        long elapsedMs = System.currentTimeMillis() - startMs;
        Assertions.assertTrue((elapsedMs <= 5000L ? 1 : 0) != 0, (String)new StringBuilder(28).append("Poll took too long, elapsed=").append(elapsedMs).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void verifyWithRetry(Function0<BoxedUnit> action) {
        int n = 0;
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void waitUntilTrue_pause;
            boolean bl;
            try {
                ++n;
                action.apply$mcV$sp();
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        return this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
    }

    public static final /* synthetic */ void $anonfun$verifyConsumerWithAuthenticationFailure$4(Consumer consumer$1) {
        Assertions.assertEquals((int)1, (int)consumer$1.poll(Duration.ofMillis(1000L)).count());
    }

    private final void describeTopic$1(Admin adminClient$1) {
        try {
            Map response = (Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).allTopicNames().get();
            Assertions.assertEquals((int)1, (int)response.size());
            response.forEach((topic, description) -> Assertions.assertEquals((int)this.numPartitions(), (int)description.partitions().size()));
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$1(IntRef attempts$1, Function0 action$2) {
        try {
            ++attempts$1.elem;
            action$2.apply$mcV$sp();
            return true;
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyWithRetry$2(IntRef attempts$1) {
        return new StringBuilder(47).append("Operation did not succeed within timeout after ").append(attempts$1.elem).toString();
    }

    public SaslClientsWithInvalidCredentialsTest() {
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.consumerCount = 1;
        this.producerCount = 1;
        this.brokerCount = 1;
        this.serverConfig().setProperty("offsets.topic.replication.factor", "1");
        this.serverConfig().setProperty("transaction.state.log.replication.factor", "1");
        this.serverConfig().setProperty("transaction.state.log.min.isr", "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
    }
}

