/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import kafka.server.ControllerNodeProvider;
import kafka.server.NodeToControllerQueueItem;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.server.ControllerRequestCompletionHandler;
import org.apache.kafka.server.NodeToControllerChannelManager;
import org.apache.kafka.server.util.MockTime;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Md\u0001B\r\u001b\u0001}A\u0001B\r\u0001\u0003\u0006\u0004%\ta\r\u0005\tu\u0001\u0011\t\u0011)A\u0005i!A1\b\u0001B\u0001B\u0003%A\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002C&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011M\u0003!\u0011!Q\u0001\n5C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0014\u0005\t+\u0002\u0011\t\u0011)A\u0005\u001b\")a\u000b\u0001C\u0001/\"9q\f\u0001b\u0001\n\u0003\u0001\u0007BB6\u0001A\u0003%\u0011\rC\u0003m\u0001\u0011\u0005S\u000eC\u0003r\u0001\u0011\u0005S\u000eC\u0003s\u0001\u0011\u00053\u000f\u0003\u0004H\u0001\u0011\u0005\u0013q\u0005\u0005\t\u0003c\u0001A\u0011\u0001\u000e\u00024!1\u00111\t\u0001\u0005\u00025<\u0011\"!\u0012\u001b\u0003\u0003E\t!a\u0012\u0007\u0011eQ\u0012\u0011!E\u0001\u0003\u0013BaA\u0016\u000b\u0005\u0002\u0005E\u0003\"CA*)E\u0005I\u0011AA+\u0011%\tY\u0007FI\u0001\n\u0003\ti\u0007C\u0005\u0002rQ\t\n\u0011\"\u0001\u0002n\t\u0011Sj\\2l\u001d>$W\rV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJT!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0004\u0001\u0001B\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005%\u0002T\"\u0001\u0016\u000b\u0005mY#BA\u000f-\u0015\tic&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002_\u0005\u0019qN]4\n\u0005ER#A\b(pI\u0016$vnQ8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s\u0003\u0019\u0019G.[3oiV\tA\u0007\u0005\u00026q5\taG\u0003\u00028W\u000591\r\\5f]R\u001c\u0018BA\u001d7\u0005)iunY6DY&,g\u000e^\u0001\bG2LWM\u001c;!\u0003\u0011!\u0018.\\3\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}R\u0013\u0001B;uS2L!!\u0011 \u0003\u00115{7m\u001b+j[\u0016\facY8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM\u001d\t\u0003\t\u0016k\u0011AG\u0005\u0003\rj\u0011acQ8oiJ|G\u000e\\3s\u001d>$W\r\u0015:pm&$WM]\u0001\u0016G>tGO]8mY\u0016\u0014\u0018\t]5WKJ\u001c\u0018n\u001c8t!\t)\u0014*\u0003\u0002Km\tyaj\u001c3f\u0003BLg+\u001a:tS>t7/\u0001\bsKR\u0014\u0018\u0010V5nK>,H/T:\u0016\u00035\u0003\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u00131!\u00138u\u0003=\u0011X\r\u001e:z)&lWm\\;u\u001bN\u0004\u0013\u0001\u0005:fcV,7\u000f\u001e+j[\u0016|W\u000f^'t\u0003E\u0011X-];fgR$\u0016.\\3pkRl5\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000faK&l\u0017/^=B\u0011A\t\u0001\u0005\u0006e)\u0001\r\u0001\u000e\u0005\u0006w)\u0001\r\u0001\u0010\u0005\u0006\u0005*\u0001\ra\u0011\u0005\b\u000f*\u0001\n\u00111\u0001I\u0011\u001dY%\u0002%AA\u00025Cq\u0001\u0016\u0006\u0011\u0002\u0003\u0007Q*A\u0006v]N,g\u000e^)vKV,W#A1\u0011\u0007\t4\u0007.D\u0001d\u0015\t!W-\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u0010\u0013\n\u0005\u001d\u001c'!F\"p]\u000e,(O]3oi2Kgn[3e\t\u0016\fX/\u001a\t\u0003\t&L!A\u001b\u000e\u000339{G-\u001a+p\u0007>tGO]8mY\u0016\u0014\u0018+^3vK&#X-\\\u0001\rk:\u001cXM\u001c;Rk\u0016,X\rI\u0001\u0006gR\f'\u000f\u001e\u000b\u0002]B\u0011aj\\\u0005\u0003a>\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0006tK:$'+Z9vKN$H\u0003\u00028u\u0003;AQ!^\bA\u0002Y\fqA]3rk\u0016\u001cH\u000fM\u0002x\u0003\u0017\u0001R\u0001_A\u0001\u0003\u000fq!!\u001f@\u000e\u0003iT!a\u001f?\u0002\u0011I,\u0017/^3tiNT!!`\u0016\u0002\r\r|W.\\8o\u0013\ty(0A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\u0011\t\u0019!!\u0002\u0003\u000f\t+\u0018\u000e\u001c3fe*\u0011qP\u001f\t\u0005\u0003\u0013\tY\u0001\u0004\u0001\u0005\u0017\u00055A/!A\u0001\u0002\u000b\u0005\u0011q\u0002\u0002\u0004?\u0012\n\u0014\u0003BA\t\u0003/\u00012ATA\n\u0013\r\t)b\u0014\u0002\b\u001d>$\b.\u001b8h!\rI\u0018\u0011D\u0005\u0004\u00037Q(aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\t\u000f\u0005}q\u00021\u0001\u0002\"\u0005A1-\u00197mE\u0006\u001c7\u000eE\u0002*\u0003GI1!!\n+\u0005\t\u001auN\u001c;s_2dWM\u001d*fcV,7\u000f^\"p[BdW\r^5p]\"\u000bg\u000e\u001a7feR\u0011\u0011\u0011\u0006\t\u0006\u0003W\ti\u0003S\u0007\u0002K&\u0019\u0011qF3\u0003\u0011=\u0003H/[8oC2\fa\u0002[1oI2,'+Z:q_:\u001cX\r\u0006\u0003\u00026\u0005\u0005Cc\u00018\u00028!9\u0011\u0011H\tA\u0002\u0005m\u0012\u0001\u0003:fgB|gn]3\u0011\u0007U\ni$C\u0002\u0002@Y\u0012ab\u00117jK:$(+Z:q_:\u001cX\rC\u0003v#\u0001\u0007\u0001.\u0001\u0003q_2d\u0017AI'pG.tu\u000eZ3U_\u000e{g\u000e\u001e:pY2,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002E)M\u0019A#a\u0013\u0011\u00079\u000bi%C\u0002\u0002P=\u0013a!\u00118z%\u00164GCAA$\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u000b\u0016\u0004\u0011\u0006e3FAA.!\u0011\ti&a\u001a\u000e\u0005\u0005}#\u0002BA1\u0003G\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015t*\u0001\u0006b]:|G/\u0019;j_:LA!!\u001b\u0002`\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\tyGK\u0002N\u00033\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0004")
public class MockNodeToControllerChannelManager
implements NodeToControllerChannelManager {
    private final MockClient client;
    private final MockTime time;
    private final ControllerNodeProvider controllerNodeProvider;
    private final NodeApiVersions controllerApiVersions;
    private final int retryTimeoutMs;
    private final int requestTimeoutMs;
    private final ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue;

    public static int $lessinit$greater$default$6() {
        return 30000;
    }

    public static int $lessinit$greater$default$5() {
        return 60000;
    }

    public static NodeApiVersions $lessinit$greater$default$4() {
        return NodeApiVersions.create();
    }

    public MockClient client() {
        return this.client;
    }

    public int retryTimeoutMs() {
        return this.retryTimeoutMs;
    }

    public int requestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public ConcurrentLinkedDeque<NodeToControllerQueueItem> unsentQueue() {
        return this.unsentQueue;
    }

    public void start() {
    }

    public void shutdown() {
    }

    public void sendRequest(AbstractRequest.Builder<? extends AbstractRequest> request, ControllerRequestCompletionHandler callback) {
        this.unsentQueue().add(new NodeToControllerQueueItem(this.time.milliseconds(), request, callback));
    }

    public Optional<NodeApiVersions> controllerApiVersions() {
        return Optional.of(this.controllerApiVersions);
    }

    public void handleResponse(NodeToControllerQueueItem request, ClientResponse response) {
        if (response.authenticationException() != null || response.versionMismatch() != null) {
            request.callback().onComplete(response);
            return;
        }
        if (response.wasDisconnected() || response.responseBody().errorCounts().containsKey(Errors.NOT_CONTROLLER)) {
            this.unsentQueue().addFirst(request);
            return;
        }
        request.callback().onComplete(response);
    }

    public void poll() {
        Iterator<NodeToControllerQueueItem> unsentIterator = this.unsentQueue().iterator();
        boolean canSend = true;
        while (canSend && unsentIterator.hasNext()) {
            NodeToControllerQueueItem queueItem = unsentIterator.next();
            if (this.time.milliseconds() - queueItem.createdTimeMs() >= (long)this.retryTimeoutMs()) {
                queueItem.callback().onTimeout();
                unsentIterator.remove();
                continue;
            }
            Option option = this.controllerNodeProvider.getControllerInfo().node();
            if (option instanceof Some) {
                Node controller = (Node)((Some)option).value();
                if (this.client().ready(controller, this.time.milliseconds())) {
                    ClientRequest clientRequest = this.client().newClientRequest(controller.idString(), queueItem.request(), queueItem.createdTimeMs(), true, this.requestTimeoutMs(), response -> this.handleResponse(queueItem, response));
                    this.client().send(clientRequest, this.time.milliseconds());
                    unsentIterator.remove();
                    continue;
                }
            }
            canSend = false;
        }
        this.client().poll(0L, this.time.milliseconds());
    }

    public MockNodeToControllerChannelManager(MockClient client, MockTime time, ControllerNodeProvider controllerNodeProvider, NodeApiVersions controllerApiVersions, int retryTimeoutMs, int requestTimeoutMs) {
        this.client = client;
        this.time = time;
        this.controllerNodeProvider = controllerNodeProvider;
        this.controllerApiVersions = controllerApiVersions;
        this.retryTimeoutMs = retryTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.unsentQueue = new ConcurrentLinkedDeque();
        client.setNodeApiVersions(controllerApiVersions);
    }
}

