/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.utilities;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.BootstrapBaseBehavior;
import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class BorderBehavior
extends BootstrapBaseBehavior {
    private IModel<Color> colorModel = Model.of((Serializable)((Object)Color.Secondary));
    private IModel<Radius> radiusModel = Model.of((Serializable)((Object)Radius.None));
    private IModel<Type> typeModel = Model.of((Serializable)((Object)Type.None));
    private IModel<Width> widthModel = Model.of();

    public void onComponentTag(Component component, ComponentTag tag) {
        super.onComponentTag(component, tag);
        Attributes.addClass(tag, (ICssClassNameProvider)this.colorModel.getObject());
        Attributes.addClass(tag, (ICssClassNameProvider)this.radiusModel.getObject());
        Attributes.addClass(tag, (ICssClassNameProvider)this.typeModel.getObject());
        Attributes.addClass(tag, (ICssClassNameProvider)this.widthModel.getObject());
    }

    public BorderBehavior color(Color color) {
        this.colorModel.setObject((Object)color);
        return this;
    }

    public BorderBehavior color(IModel<Color> colorModel) {
        this.colorModel = colorModel;
        return this;
    }

    public BorderBehavior radius(Radius radius) {
        this.radiusModel.setObject((Object)radius);
        return this;
    }

    public BorderBehavior radius(IModel<Radius> radiusModel) {
        this.radiusModel = radiusModel;
        return this;
    }

    public BorderBehavior type(Type type) {
        this.typeModel.setObject((Object)type);
        return this;
    }

    public BorderBehavior type(IModel<Type> typeModel) {
        this.typeModel = typeModel;
        return this;
    }

    public BorderBehavior width(Width width) {
        this.widthModel.setObject((Object)width);
        return this;
    }

    public BorderBehavior width(IModel<Width> widthModel) {
        this.widthModel = widthModel;
        return this;
    }

    public static enum Color implements ICssClassNameProvider
    {
        Primary("primary"),
        Primary_subtle("primary-subtle"),
        Secondary("secondary"),
        Secondary_subtle("secondary-subtle"),
        Success("success"),
        Success_subtle("success-subtle"),
        Danger("danger"),
        Danger_subtle("danger-subtle"),
        Warning("warning"),
        Warning_subtle("warning-subtle"),
        Info("info"),
        Info_subtle("info-subtle"),
        Light("light"),
        Light_subtle("light-subtle"),
        Dark("dark"),
        Dark_subtle("dark-subtle"),
        Black("black"),
        White("white");

        private final String cssClassName;

        private Color(String value) {
            this.cssClassName = "border-" + value;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }

    public static enum Radius implements ICssClassNameProvider
    {
        All("rounded"),
        Top("rounded-top"),
        Right("rounded-end"),
        Bottom("rounded-bottom"),
        Left("rounded-start"),
        Circle("rounded-circle"),
        Pill("rounded-pill"),
        None("rounded-0");

        private final String value;

        private Radius(String value) {
            this.value = value;
        }

        @Override
        public String cssClassName() {
            return this.value;
        }
    }

    public static enum Type implements ICssClassNameProvider
    {
        All("border"),
        Top("border-top"),
        Right("border-end"),
        Bottom("border-bottom"),
        Left("border-start"),
        ExceptTop("border-top-0"),
        ExceptRight("border-end-0"),
        ExceptBottom("border-bottom-0"),
        ExceptLeft("border-start-0"),
        None("border-0");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @Override
        public String cssClassName() {
            return this.value;
        }
    }

    public static enum Width implements ICssClassNameProvider
    {
        Width_1(1),
        Width_2(2),
        Width_3(3),
        Width_4(4),
        Width_5(5);

        private final String cssClassName;

        private Width(int width) {
            this.cssClassName = "border-" + width;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }
}

