/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.dialog.Modal;
import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.commons.ITabComponent;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.layout.AnyLayout;
import org.apache.syncope.client.console.layout.AnyLayoutUtils;
import org.apache.syncope.client.console.panels.AnyPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.panels.PropagationErrorPanel;
import org.apache.syncope.client.console.panels.RealmDetails;
import org.apache.syncope.client.console.panels.RealmWizardBuilder;
import org.apache.syncope.client.console.panels.RemoteObjectPanel;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.ConnObjectPanel;
import org.apache.syncope.client.ui.commons.status.StatusUtils;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.ExecStatus;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Realm
extends WizardMgtPanel<RealmTO> {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(Realm.class);
    @SpringBean
    protected RoleRestClient roleRestClient;
    @SpringBean
    protected RealmRestClient realmRestClient;
    protected final RealmTO realmTO;
    protected final List<AnyTypeTO> anyTypes;
    protected final int selectedIndex;
    protected final RealmWizardBuilder wizardBuilder;

    public Realm(String id, RealmTO realmTO, List<AnyTypeTO> anyTypes, int selectedIndex, PageReference pageRef) {
        super(id, true);
        this.realmTO = realmTO;
        this.anyTypes = anyTypes;
        this.selectedIndex = selectedIndex;
        this.setPageRef(pageRef);
        this.addInnerObject(new Component[]{new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList(pageRef)).setSelectedTab(selectedIndex)});
        this.wizardBuilder = this.buildNewItemPanelBuilder(pageRef);
        this.addNewItemPanelBuilder(this.wizardBuilder, false);
        this.setShowResultPanel(true);
        this.modal.size(Modal.Size.Large);
        this.setWindowClosedReloadCallback(this.modal);
    }

    protected RealmWizardBuilder buildNewItemPanelBuilder(PageReference pageRef) {
        return new RealmWizardBuilder(this.realmRestClient, pageRef);
    }

    public RealmTO getRealmTO() {
        return this.realmTO;
    }

    protected List<ITab> buildTabList(final PageReference pageRef) {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add(new RealmDetailsTabPanel());
        final AnyLayout anyLayout = AnyLayoutUtils.fetch(this.roleRestClient, this.anyTypes.stream().map(AnyTypeTO::getKey).toList());
        for (final AnyTypeTO anyType : this.anyTypes) {
            tabs.add(new ITabComponent((IModel)new ResourceModel("anyType." + anyType.getKey(), anyType.getKey()), new String[]{String.format("%s_SEARCH", anyType.getKey())}){
                private static final long serialVersionUID = 1169585538404171118L;

                @Override
                public WebMarkupContainer getPanel(String panelId) {
                    return new AnyPanel.Builder(anyLayout.getAnyPanelClass(), panelId, anyType, Realm.this.realmTO, anyLayout, true, pageRef).build();
                }

                @Override
                public boolean isVisible() {
                    return SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
                }
            });
        }
        return tabs;
    }

    @Override
    protected Panel customResultBody(String panelId, RealmTO item, Serializable result) {
        if (!(result instanceof ProvisioningResult)) {
            throw new IllegalStateException("Unsupported result type");
        }
        ProvisioningResult provisioningResult = (ProvisioningResult)result;
        final MultilevelPanel mlp = new MultilevelPanel(panelId);
        this.add(new Component[]{mlp});
        PropagationStatus syncope = new PropagationStatus();
        syncope.setStatus(ExecStatus.SUCCESS);
        syncope.setResource("syncope");
        ArrayList<PropagationStatus> propagations = new ArrayList<PropagationStatus>();
        propagations.add(syncope);
        propagations.addAll(provisioningResult.getPropagationStatuses());
        ListViewPanel.Builder<PropagationStatus> builder = new ListViewPanel.Builder<PropagationStatus>(PropagationStatus.class, this.pageRef){
            private static final long serialVersionUID = -6809736686861678498L;

            @Override
            protected Component getValueComponent(String key, PropagationStatus bean) {
                if ("afterObj".equalsIgnoreCase(key)) {
                    String remoteId = Optional.ofNullable(bean.getAfterObj()).flatMap(afterObj -> afterObj.getAttr("__NAME__").filter(s -> !s.getValues().isEmpty()).map(s -> (String)s.getValues().getFirst())).orElse("");
                    return new Label("field", (Serializable)((Object)remoteId));
                }
                if ("status".equalsIgnoreCase(key)) {
                    return StatusUtils.getStatusImagePanel((String)"field", (ExecStatus)bean.getStatus());
                }
                return super.getValueComponent(key, bean);
            }
        };
        builder.setItems(propagations);
        builder.includes("resource", "afterObj", "status");
        builder.withChecks(ListViewPanel.CheckAvailability.NONE);
        builder.setReuseItem(false);
        ActionLink<PropagationStatus> connObjectLink = new ActionLink<PropagationStatus>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(PropagationStatus bean) {
                return !"syncope".equals(bean.getResource()) && (ExecStatus.CREATED == bean.getStatus() || ExecStatus.SUCCESS == bean.getStatus());
            }

            @Override
            public void onClick(AjaxRequestTarget target, PropagationStatus status) {
                mlp.next(status.getResource(), new RemoteRealmPanel(status), target);
            }
        };
        SyncopeWebApplication.get().getStatusProvider().addConnObjectLink(builder, connObjectLink);
        builder.addAction(new ActionLink<PropagationStatus>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            protected boolean statusCondition(PropagationStatus status) {
                return StringUtils.isNotBlank((CharSequence)status.getFailureReason());
            }

            @Override
            public void onClick(AjaxRequestTarget target, PropagationStatus status) {
                mlp.next(status.getResource(), new PropagationErrorPanel(status.getFailureReason()), target);
            }
        }, ActionLink.ActionType.PROPAGATION_TASKS, "");
        mlp.setFirstLevel((Panel)builder.build("first"));
        return mlp;
    }

    protected abstract void onClickTemplate(AjaxRequestTarget var1);

    protected abstract void onClickCreate(AjaxRequestTarget var1);

    protected abstract void onClickEdit(AjaxRequestTarget var1, RealmTO var2);

    protected abstract void onClickAudit(AjaxRequestTarget var1, RealmTO var2);

    protected abstract void onClickDelete(AjaxRequestTarget var1, RealmTO var2);

    protected class RealmDetailsTabPanel
    extends ITabComponent {
        private static final long serialVersionUID = -5861786415855103549L;

        protected RealmDetailsTabPanel() {
            super((IModel<String>)new ResourceModel("realm.details", "DETAILS"), "REALM_CREATE", "REALM_UPDATE", "REALM_DELETE");
        }

        public Panel getPanel(String panelId) {
            ActionsPanel<RealmTO> actionPanel = new ActionsPanel<RealmTO>("actions", null);
            if (this.securityCheck(Set.of("REALM_CREATE"))) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379827L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickCreate(target);
                    }
                }, ActionLink.ActionType.CREATE, "REALM_CREATE").hideLabel();
            }
            if (this.securityCheck(Set.of("REALM_UPDATE"))) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379828L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickEdit(target, Realm.this.realmTO);
                    }
                }, ActionLink.ActionType.EDIT, "REALM_UPDATE").hideLabel();
            }
            if (this.securityCheck(Set.of("REALM_UPDATE"))) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379827L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickTemplate(target);
                    }
                }, ActionLink.ActionType.TEMPLATE, "REALM_UPDATE").hideLabel();
            }
            if (this.securityCheck(Set.of("AUDIT_LIST"))) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379827L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickAudit(target, Realm.this.realmTO);
                    }
                }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, "AUDIT_LIST").hideLabel();
            }
            if (this.securityCheck(Set.of("REALM_DELETE"))) {
                actionPanel.add(new ActionLink<RealmTO>(Realm.this.realmTO){
                    private static final long serialVersionUID = 2802988981431379829L;

                    @Override
                    public void onClick(AjaxRequestTarget target, RealmTO ignore) {
                        Realm.this.onClickDelete(target, Realm.this.realmTO);
                    }
                }, ActionLink.ActionType.DELETE, "REALM_DELETE", true).hideLabel();
            }
            RealmDetails panel = new RealmDetails(panelId, Realm.this.realmTO, actionPanel, false);
            panel.setContentEnabled(false);
            actionPanel.setEnabled(true);
            return panel;
        }

        @Override
        public boolean isVisible() {
            return SyncopeWebApplication.get().getSecuritySettings().getAuthorizationStrategy().isActionAuthorized((Component)this, RENDER);
        }

        private boolean securityCheck(Set<String> entitlements) {
            return entitlements.stream().anyMatch(e -> SyncopeConsoleSession.get().owns((String)e, Realm.this.realmTO.getFullPath()));
        }
    }

    protected static class RemoteRealmPanel
    extends RemoteObjectPanel {
        private static final long serialVersionUID = 4303365227411467563L;
        protected final PropagationStatus bean;

        protected RemoteRealmPanel(PropagationStatus bean) {
            this.bean = bean;
            this.add(new Component[]{new ConnObjectPanel("remoteObject", Pair.of((Object)new ResourceModel("before"), (Object)new ResourceModel("after")), this.getStatusProviderInfo(), false)});
        }

        @Override
        protected StatusProvider.Info getStatusProviderInfo() {
            return new StatusProvider.Info(this.bean.getBeforeObj(), this.bean.getAfterObj());
        }
    }
}

