/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web.flow.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityUniversalPromptCredential;
import org.apereo.cas.adaptors.duo.web.flow.action.DuoSecurityAuthenticationWebflowAction;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.pac4j.BrowserWebStorageSessionStore;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.ticket.TransientSessionTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.scope.ConversationScope;
import org.springframework.webflow.scope.FlashScope;
import org.springframework.webflow.scope.FlowScope;
import org.springframework.webflow.scope.RequestScope;

public class DuoSecurityUniversalPromptValidateLoginAction
extends DuoSecurityAuthenticationWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DuoSecurityUniversalPromptValidateLoginAction.class);
    static final String REQUEST_PARAMETER_CODE = "duo_code";
    static final String REQUEST_PARAMETER_STATE = "state";
    private final BrowserWebStorageSessionStore sessionStore;
    private final TicketRegistry ticketRegistry;

    public DuoSecurityUniversalPromptValidateLoginAction(CasWebflowEventResolver duoAuthenticationWebflowEventResolver, BrowserWebStorageSessionStore sessionStore, TicketRegistry ticketRegistry) {
        super(duoAuthenticationWebflowEventResolver);
        this.sessionStore = sessionStore;
        this.ticketRegistry = ticketRegistry;
    }

    @Override
    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        if (requestParameters.contains(REQUEST_PARAMETER_CODE) && requestParameters.contains(REQUEST_PARAMETER_STATE)) {
            return this.handleDuoSecurityUniversalPromptResponse(requestContext);
        }
        return new EventFactorySupport().event((Object)this, "skip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event handleDuoSecurityUniversalPromptResponse(RequestContext requestContext) throws Throwable {
        String duoState = (String)WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)REQUEST_PARAMETER_STATE).orElseThrow();
        LOGGER.trace("Received Duo Security state [{}]", (Object)duoState);
        Event resultingEvent = this.processStateFromTicketRegistry(requestContext, duoState);
        if (resultingEvent != null) {
            if (StringUtils.equalsIgnoreCase((CharSequence)resultingEvent.getId(), (CharSequence)"success")) {
                try {
                    Event event = super.doExecuteInternal(requestContext);
                    return event;
                }
                finally {
                    TransientSessionTicket ticket = (TransientSessionTicket)resultingEvent.getAttributes().getRequired("result", TransientSessionTicket.class);
                    Credential credential = (Credential)ticket.getProperty(Credential.class.getSimpleName(), Credential.class);
                    WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
                }
            }
            return resultingEvent;
        }
        return this.processStateFromBrowserStorage(requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Event processStateFromBrowserStorage(RequestContext requestContext) throws Exception {
        Optional browserStorage = WebUtils.getBrowserStoragePayload((RequestContext)requestContext);
        if (browserStorage.isEmpty()) {
            WebUtils.putTargetTransition((RequestContext)requestContext, (String)"switch");
            WebUtils.putTargetState((RequestContext)requestContext, (String)requestContext.getCurrentState().getId());
            WebUtils.putBrowserStorageContextKey((RequestContext)requestContext, (String)this.sessionStore.getBrowserStorageContextKey());
            return new EventFactorySupport().event((Object)this, "restore");
        }
        BrowserWebStorageSessionStore browserSessionStore = null;
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        try {
            browserSessionStore = this.sessionStore.buildFromTrackableSession((WebContext)webContext, browserStorage.get()).map(BrowserWebStorageSessionStore.class::cast).orElseThrow(() -> new IllegalArgumentException("Unable to determine Duo authentication context from session store"));
            browserSessionStore.getSessionAttributes((WebContext)webContext).forEach((key, value) -> {
                if (key.equalsIgnoreCase(FlowScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getFlowScope());
                } else if (key.equalsIgnoreCase(FlashScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getFlashScope());
                } else if (key.equalsIgnoreCase(RequestScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getRequestScope());
                } else if (key.equalsIgnoreCase(ConversationScope.class.getSimpleName())) {
                    DuoSecurityUniversalPromptValidateLoginAction.populateRequestContextScope(value, (MutableAttributeMap<Object>)requestContext.getConversationScope());
                } else {
                    requestContext.getFlowScope().put(key, value);
                }
            });
            this.populateContextWithCredential(requestContext, browserSessionStore);
            this.populateContextWithAuthentication(requestContext, browserSessionStore);
            this.populateContextWithService(requestContext, browserSessionStore);
            Event event = super.doExecuteInternal(requestContext);
            return event;
        }
        catch (Throwable e) {
            LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
        }
        finally {
            if (browserSessionStore != null) {
                Credential credential = (Credential)browserSessionStore.getSessionAttributes((WebContext)webContext).get(Credential.class.getSimpleName());
                WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
            }
        }
        return new EventFactorySupport().event((Object)this, "error");
    }

    private static JEEContext toWebContext(RequestContext requestContext) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        return new JEEContext(request, response);
    }

    private static void populateRequestContextScope(Object flowAttributes, MutableAttributeMap<Object> requestContext) {
        LinkedHashMap mappedAttributes = new LinkedHashMap((Map)flowAttributes);
        CollectionUtils.filter(mappedAttributes.values(), (Predicate)PredicateUtils.notNullPredicate());
        requestContext.putAll((AttributeMap)new LocalAttributeMap(mappedAttributes));
    }

    protected void populateContextWithService(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        RegisteredService registeredService = (RegisteredService)sessionStorage.getSessionAttributes((WebContext)webContext).get(RegisteredService.class.getSimpleName());
        Service service = (Service)sessionStorage.getSessionAttributes((WebContext)webContext).get(Service.class.getSimpleName());
        this.populateContextWithService(requestContext, registeredService, service);
    }

    protected void populateContextWithService(RequestContext requestContext, TransientSessionTicket ticket) {
        RegisteredService registeredService = (RegisteredService)ticket.getProperty(RegisteredService.class.getSimpleName(), RegisteredService.class);
        this.populateContextWithService(requestContext, registeredService, ticket.getService());
    }

    protected void populateContextWithService(RequestContext requestContext, RegisteredService registeredService, Service service) {
        WebUtils.putRegisteredService((RequestContext)requestContext, (RegisteredService)registeredService);
        LOGGER.debug("Restored registered service [{}] into webflow context", (Object)registeredService);
        WebUtils.putServiceIntoFlowScope((RequestContext)requestContext, (Service)service);
        LOGGER.debug("Restored service [{}] into webflow context", (Object)service);
    }

    protected void populateContextWithCredential(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        Authentication authentication = (Authentication)sessionStorage.getSessionAttributes((WebContext)webContext).get(Authentication.class.getSimpleName());
        String duoCode = (String)WebUtils.getRequestParameterOrAttribute((RequestContext)requestContext, (String)REQUEST_PARAMETER_CODE).orElseThrow();
        String duoSecurityIdentifier = (String)sessionStorage.getSessionAttributes((WebContext)webContext).get("duoProviderId");
        this.populateContextWithCredential(requestContext, authentication, duoCode, duoSecurityIdentifier);
    }

    protected void populateContextWithCredential(RequestContext requestContext, TransientSessionTicket ticket, Authentication authentication) {
        ParameterMap requestParameters = requestContext.getRequestParameters();
        String duoCode = (String)requestParameters.get(REQUEST_PARAMETER_CODE, String.class);
        String duoSecurityIdentifier = (String)ticket.getProperty("duoProviderId", String.class);
        this.populateContextWithCredential(requestContext, authentication, duoCode, duoSecurityIdentifier);
    }

    protected void populateContextWithCredential(RequestContext requestContext, Authentication authentication, String duoCode, String duoSecurityIdentifier) {
        LOGGER.trace("Received Duo Security code [{}] for Duo Security identifier [{}]", (Object)duoCode, (Object)duoSecurityIdentifier);
        DuoSecurityUniversalPromptCredential credential = new DuoSecurityUniversalPromptCredential(duoCode, authentication);
        ApplicationContext applicationContext = requestContext.getActiveFlow().getApplicationContext();
        MultifactorAuthenticationProvider provider = (MultifactorAuthenticationProvider)MultifactorAuthenticationUtils.getMultifactorAuthenticationProviderById((String)duoSecurityIdentifier, (ApplicationContext)applicationContext).orElseThrow(() -> new IllegalArgumentException("Unable to locate multifactor authentication provider by id " + duoSecurityIdentifier));
        credential.setProviderId(provider.getId());
        WebUtils.putCredential((RequestContext)requestContext, (Credential)credential);
    }

    protected void populateContextWithAuthentication(RequestContext requestContext, BrowserWebStorageSessionStore sessionStorage) throws Throwable {
        JEEContext webContext = DuoSecurityUniversalPromptValidateLoginAction.toWebContext(requestContext);
        AuthenticationResultBuilder authenticationResultBuilder = (AuthenticationResultBuilder)sessionStorage.getSessionAttributes((WebContext)webContext).get(AuthenticationResultBuilder.class.getSimpleName());
        Service service = (Service)sessionStorage.getSessionAttributes((WebContext)webContext).get(Service.class.getSimpleName());
        this.populateContextWithAuthentication(requestContext, authenticationResultBuilder, service);
    }

    protected void populateContextWithAuthentication(RequestContext requestContext, TransientSessionTicket ticket) throws Throwable {
        AuthenticationResultBuilder authenticationResultBuilder = (AuthenticationResultBuilder)ticket.getProperty(AuthenticationResultBuilder.class.getSimpleName(), AuthenticationResultBuilder.class);
        Service service = (Service)ticket.getProperty(Service.class.getSimpleName(), Service.class);
        this.populateContextWithAuthentication(requestContext, authenticationResultBuilder, service);
    }

    protected void populateContextWithAuthentication(RequestContext requestContext, AuthenticationResultBuilder authenticationResultBuilder, Service service) throws Throwable {
        WebUtils.putAuthenticationResultBuilder((AuthenticationResultBuilder)authenticationResultBuilder, (RequestContext)requestContext);
        AuthenticationResult authenticationResult = authenticationResultBuilder.build(service);
        WebUtils.putAuthenticationResult((AuthenticationResult)authenticationResult, (RequestContext)requestContext);
        WebUtils.putAuthentication((Authentication)authenticationResult.getAuthentication(), (RequestContext)requestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event processStateFromTicketRegistry(RequestContext requestContext, String duoState) throws Exception {
        if (duoState.startsWith("TST")) {
            TransientSessionTicket ticket = null;
            try {
                ticket = (TransientSessionTicket)this.ticketRegistry.getTicket(duoState, TransientSessionTicket.class);
                if (ticket != null) {
                    Authentication authentication = (Authentication)ticket.getProperty(Authentication.class.getSimpleName(), Authentication.class);
                    this.populateContextWithCredential(requestContext, ticket, authentication);
                    this.populateContextWithAuthentication(requestContext, ticket);
                    this.populateContextWithService(requestContext, ticket);
                    Event event = this.success(ticket);
                    return event;
                }
            }
            catch (Throwable e) {
                LoggingUtils.warn((Logger)LOGGER, (Throwable)e);
                Event event = new EventFactorySupport().event((Object)this, "error");
                return event;
            }
            finally {
                if (ticket != null) {
                    Map flowScope = (Map)ticket.getProperty(FlowScope.class.getSimpleName(), Map.class);
                    requestContext.getFlowScope().putAll((AttributeMap)new LocalAttributeMap(flowScope));
                }
                this.ticketRegistry.deleteTicket(duoState);
            }
        }
        return null;
    }
}

