/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.runtime.ProcessInstanceStartEventSubscriptionBuilder;
import org.flowable.eventsubscription.api.EventSubscription;

public class ProcessInstanceStartEventSubscriptionBuilderImpl
implements ProcessInstanceStartEventSubscriptionBuilder {
    protected final RuntimeServiceImpl runtimeService;
    protected String processDefinitionKey;
    protected String tenantId;
    protected final Map<String, Object> correlationParameterValues = new HashMap<String, Object>();
    protected boolean doNotUpdateToLatestVersionAutomatically;

    public ProcessInstanceStartEventSubscriptionBuilderImpl(RuntimeServiceImpl runtimeService) {
        this.runtimeService = runtimeService;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionBuilder processDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionBuilder doNotUpdateToLatestVersionAutomatically() {
        this.doNotUpdateToLatestVersionAutomatically = true;
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionBuilder addCorrelationParameterValue(String parameterName, Object parameterValue) {
        this.correlationParameterValues.put(parameterName, parameterValue);
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionBuilder addCorrelationParameterValues(Map<String, Object> parameters) {
        this.correlationParameterValues.putAll(parameters);
        return this;
    }

    @Override
    public ProcessInstanceStartEventSubscriptionBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public Map<String, Object> getCorrelationParameterValues() {
        return this.correlationParameterValues;
    }

    public boolean isDoNotUpdateToLatestVersionAutomatically() {
        return this.doNotUpdateToLatestVersionAutomatically;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public EventSubscription subscribe() {
        this.checkValidInformation();
        return this.runtimeService.registerProcessInstanceStartEventSubscription(this);
    }

    protected void checkValidInformation() {
        if (StringUtils.isEmpty((CharSequence)this.processDefinitionKey)) {
            throw new FlowableIllegalArgumentException("The process definition must be provided using the key for the subscription to be registered.");
        }
        if (this.correlationParameterValues.isEmpty()) {
            throw new FlowableIllegalArgumentException("At least one correlation parameter value must be provided for a dynamic process start event subscription, otherwise the process would get started on all events, regardless their correlation parameter values.");
        }
    }
}

