/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.kafka.common.message.PushTelemetryRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.requests.PushTelemetryRequest;
import org.apache.kafka.common.requests.PushTelemetryResponse;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryUtils;
import org.apache.kafka.common.telemetry.internals.MetricKey;
import org.apache.kafka.common.telemetry.internals.SinglePointMetric;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class PushTelemetryRequestTest {
    @Test
    public void testGetErrorResponse() {
        PushTelemetryRequest req = new PushTelemetryRequest(new PushTelemetryRequestData(), 0);
        PushTelemetryResponse response = req.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @ParameterizedTest
    @EnumSource(value=CompressionType.class)
    public void testMetricsDataCompression(CompressionType compressionType) throws IOException {
        MetricsData metricsData = this.getMetricsData();
        PushTelemetryRequest req = this.getPushTelemetryRequest(metricsData, compressionType);
        ByteBuffer receivedMetricsBuffer = req.metricsData();
        Assertions.assertNotNull((Object)receivedMetricsBuffer);
        Assertions.assertTrue((receivedMetricsBuffer.capacity() > 0 ? 1 : 0) != 0);
        MetricsData receivedData = ClientTelemetryUtils.deserializeMetricsData((ByteBuffer)receivedMetricsBuffer);
        Assertions.assertEquals((Object)metricsData, (Object)receivedData);
    }

    private PushTelemetryRequest getPushTelemetryRequest(MetricsData metricsData, CompressionType compressionType) throws IOException {
        byte[] data = metricsData.toByteArray();
        byte[] compressedData = ClientTelemetryUtils.compress((byte[])data, (CompressionType)compressionType);
        if (compressionType != CompressionType.NONE) {
            Assertions.assertTrue((compressedData.length < data.length ? 1 : 0) != 0);
        } else {
            Assertions.assertArrayEquals((byte[])compressedData, (byte[])data);
        }
        return (PushTelemetryRequest)new PushTelemetryRequest.Builder(new PushTelemetryRequestData().setMetrics(compressedData).setCompressionType(compressionType.id)).build();
    }

    private MetricsData getMetricsData() {
        ArrayList<Metric> metricsList = new ArrayList<Metric>();
        metricsList.add(SinglePointMetric.sum((MetricKey)new MetricKey("metricName"), (double)1.0, (boolean)true, (Instant)Instant.now(), null, Collections.emptySet()).builder().build());
        metricsList.add(SinglePointMetric.sum((MetricKey)new MetricKey("metricName1"), (double)100.0, (boolean)false, (Instant)Instant.now(), (Instant)Instant.now(), Collections.emptySet()).builder().build());
        metricsList.add(SinglePointMetric.deltaSum((MetricKey)new MetricKey("metricName2"), (double)1.0, (boolean)true, (Instant)Instant.now(), (Instant)Instant.now(), Collections.emptySet()).builder().build());
        metricsList.add(SinglePointMetric.gauge((MetricKey)new MetricKey("metricName3"), (double)1.0, (Instant)Instant.now(), Collections.emptySet()).builder().build());
        metricsList.add(SinglePointMetric.gauge((MetricKey)new MetricKey("metricName4"), (Number)100L, (Instant)Instant.now(), Collections.emptySet()).builder().build());
        MetricsData.Builder builder = MetricsData.newBuilder();
        for (Metric metric : metricsList) {
            ResourceMetrics rm = ResourceMetrics.newBuilder().setResource(Resource.newBuilder().build()).addScopeMetrics(ScopeMetrics.newBuilder().addMetrics(metric).build()).build();
            builder.addResourceMetrics(rm);
        }
        return builder.build();
    }
}

