/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.authentication;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;

public class ExceptionMappingAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private final Map<String, String> failureUrlMap = new HashMap<String, String>();

    @Override
    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        String url = this.failureUrlMap.get(((Object)((Object)exception)).getClass().getName());
        if (url != null) {
            this.getRedirectStrategy().sendRedirect(request, response, url);
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    public void setExceptionMappings(Map<?, ?> failureUrlMap) {
        this.failureUrlMap.clear();
        for (Map.Entry<?, ?> entry : failureUrlMap.entrySet()) {
            Object exception = entry.getKey();
            Object url = entry.getValue();
            Assert.isInstanceOf(String.class, exception, (String)"Exception key must be a String (the exception classname).");
            Assert.isInstanceOf(String.class, url, (String)"URL must be a String");
            Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)url), () -> "Not a valid redirect URL: " + String.valueOf(url));
            this.failureUrlMap.put((String)exception, (String)url);
        }
    }
}

