/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.tika.utils.ExceptionUtils;

public class EvalExceptionUtils {
    private static final Pattern CAUSED_BY_SNIPPER = Pattern.compile("(Caused by: [^:]+):[^\\r\\n]+");

    public static String normalize(String stacktrace) {
        if (StringUtils.isBlank(stacktrace)) {
            return "";
        }
        String sortTrace = ExceptionUtils.trimMessage(stacktrace);
        Matcher matcher = CAUSED_BY_SNIPPER.matcher(sortTrace);
        sortTrace = matcher.replaceAll("$1");
        return sortTrace.replaceAll("org.apache.tika.", "o.a.t.");
    }
}

