/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.csv;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.ProxyReader;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.csv.CSVResult;
import org.apache.tika.parser.csv.TextAndCSVParser;

class CSVSniffer {
    static final int EOF = -1;
    static final int NEW_LINE = 10;
    static final int CARRIAGE_RETURN = 13;
    private static final int DEFAULT_MARK_LIMIT = 10000;
    private static final double DEFAULT_MIN_CONFIDENCE = 0.5;
    private static final int PUSH_BACK = 2;
    private static final int SPACE = 32;
    private final Set<Character> delimiters;
    private final int markLimit;
    private final double minConfidence;

    CSVSniffer(Set<Character> delimiters) {
        this(10000, delimiters, 0.5);
    }

    CSVSniffer(int markLimit, Set<Character> delimiters, double minConfidence) {
        this.markLimit = markLimit;
        this.delimiters = delimiters;
        this.minConfidence = minConfidence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CSVResult> sniff(Reader reader) throws IOException {
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        ArrayList<CSVResult> ret = new ArrayList<CSVResult>();
        for (char delimiter : this.delimiters) {
            reader.mark(this.markLimit);
            try {
                CSVResult result = new Snifflet(delimiter).sniff(reader);
                ret.add(result);
            }
            finally {
                reader.reset();
            }
        }
        Collections.sort(ret);
        return ret;
    }

    CSVResult getBest(Reader reader, Metadata metadata) throws IOException {
        List<CSVResult> results = this.sniff(reader);
        if (results == null || results.isEmpty()) {
            return CSVResult.TEXT;
        }
        CSVResult bestResult = results.get(0);
        if (bestResult.getConfidence() < this.minConfidence) {
            return CSVResult.TEXT;
        }
        if (results.size() > 1 && bestResult.getDelimiter().equals(Character.valueOf(':')) && Math.abs(results.get(1).getConfidence() - bestResult.getConfidence()) < 1.0E-4) {
            return results.get(1);
        }
        return bestResult;
    }

    private static class CloseShieldReader
    extends ProxyReader {
        public CloseShieldReader(Reader r) {
            super(r);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private class Snifflet {
        private final char delimiter;
        private final char quoteCharacter = (char)34;
        Map<Integer, MutableInt> rowLengthCounts = new HashMap<Integer, MutableInt>();
        int charsRead = 0;
        int colCount = 0;
        boolean rowZero = true;
        boolean rowZeroEmpty = false;
        int encapsulated = 0;
        boolean parseException = false;

        public Snifflet(char delimiter) {
            this.delimiter = delimiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CSVResult sniff(Reader r) throws IOException {
            boolean eof = false;
            boolean hitMarkLimit = false;
            int lastC = -1;
            StringBuilder unquoted = new StringBuilder();
            try (PushbackReader reader = new PushbackReader(new CloseShieldReader(r), 2);){
                int c = this.read(reader);
                while (c != -1) {
                    if (c == 34) {
                        this.handleUnquoted(unquoted);
                        if (lastC > -1 && lastC != this.delimiter && lastC != 10 && lastC != 13) {
                            this.parseException = true;
                            CSVResult cSVResult = this.calcResult();
                            return cSVResult;
                        }
                        boolean correctlyEncapsulated = this.consumeQuoted(reader, 34);
                        if (!correctlyEncapsulated) {
                            this.parseException = true;
                            CSVResult cSVResult = this.calcResult();
                            return cSVResult;
                        }
                    } else if (c == this.delimiter) {
                        this.handleUnquoted(unquoted);
                        this.endColumn();
                        this.consumeSpaceCharacters(reader);
                    } else if (c == 10 || c == 13) {
                        if (unquoted.length() > 0) {
                            this.endColumn();
                        }
                        this.handleUnquoted(unquoted);
                        this.endRow();
                        this.consumeNewLines(reader);
                    } else {
                        unquoted.append((char)c);
                    }
                    lastC = c;
                    c = this.read(reader);
                }
            }
            catch (HitMarkLimitException e) {
                hitMarkLimit = true;
            }
            catch (UnsurprisingEOF e) {
            }
            catch (EOFException e) {
                eof = true;
            }
            finally {
                r.reset();
            }
            if (!hitMarkLimit && !eof && lastC != 10 && lastC != 13) {
                this.handleUnquoted(unquoted);
                this.endColumn();
                this.endRow();
            }
            return this.calcResult();
        }

        private CSVResult calcResult() {
            double confidence = this.getConfidence();
            MediaType mediaType = TextAndCSVParser.CSV;
            if (this.delimiter == '\t') {
                mediaType = TextAndCSVParser.TSV;
            }
            return new CSVResult(confidence, mediaType, Character.valueOf(this.delimiter));
        }

        private void handleUnquoted(StringBuilder unquoted) {
            if (unquoted.length() > 0) {
                this.unquoted(unquoted.toString());
                unquoted.setLength(0);
            }
        }

        void consumeSpaceCharacters(PushbackReader reader) throws IOException {
            int c = this.read(reader);
            while (c == 32) {
                c = this.read(reader);
            }
            if (c == -1) {
                throw new UnsurprisingEOF();
            }
            this.unread(reader, c);
        }

        boolean consumeQuoted(PushbackReader reader, int quoteCharacter) throws IOException {
            int c = this.read(reader);
            while (c != -1) {
                if (c == quoteCharacter) {
                    int nextC = this.read(reader);
                    if (nextC == -1) {
                        ++this.encapsulated;
                        this.endColumn();
                        throw new UnsurprisingEOF();
                    }
                    if (nextC != quoteCharacter) {
                        ++this.encapsulated;
                        this.endColumn();
                        this.unread(reader, nextC);
                        this.consumeSpaceCharacters(reader);
                        nextC = this.read(reader);
                        if (nextC == -1) {
                            throw new UnsurprisingEOF();
                        }
                        if (nextC == 10 || nextC == 13) {
                            this.unread(reader, nextC);
                            return true;
                        }
                        if (nextC != this.delimiter) {
                            this.unread(reader, nextC);
                            return false;
                        }
                        this.unread(reader, nextC);
                        return true;
                    }
                }
                c = this.read(reader);
            }
            throw new EOFException();
        }

        private int read(PushbackReader reader) throws IOException {
            if (this.charsRead >= CSVSniffer.this.markLimit - 1) {
                throw new HitMarkLimitException();
            }
            int c = reader.read();
            if (c == -1) {
                return -1;
            }
            ++this.charsRead;
            return c;
        }

        private void unread(PushbackReader reader, int c) throws IOException {
            if (c != -1) {
                reader.unread(c);
                --this.charsRead;
            }
        }

        void consumeNewLines(PushbackReader reader) throws IOException {
            int c = this.read(reader);
            while (c == 10 || c == 13) {
                c = this.read(reader);
            }
            if (c == -1) {
                throw new EOFException();
            }
            this.unread(reader, c);
        }

        void endColumn() {
            ++this.colCount;
        }

        void endRow() {
            MutableInt cnt = this.rowLengthCounts.get(this.colCount);
            if (cnt == null) {
                cnt = new MutableInt(1);
                this.rowLengthCounts.put(this.colCount, cnt);
            } else {
                cnt.increment();
            }
            if (this.rowZero && this.colCount <= 1) {
                this.rowZeroEmpty = true;
            }
            this.colCount = 0;
            this.rowZero = false;
        }

        void unquoted(String string) {
        }

        double getConfidence() {
            double confidence = 0.0;
            if (this.parseException) {
                return -1.0;
            }
            double colCountConsistencyConf = this.calculateColumnCountConsistency();
            if (colCountConsistencyConf > -1.0) {
                confidence = colCountConsistencyConf;
            }
            double encapsulatedBonus = 0.0;
            if (this.encapsulated > 0) {
                encapsulatedBonus = 1.0 - 1.0 / Math.pow(this.encapsulated, 0.2);
            }
            return Math.min(confidence + encapsulatedBonus, 1.0);
        }

        private double calculateColumnCountConsistency() {
            int max = -1;
            int totalRows = 0;
            for (Map.Entry<Integer, MutableInt> e : this.rowLengthCounts.entrySet()) {
                int numCols = e.getKey();
                int count = e.getValue().intValue();
                if (numCols > 1 && count > max) {
                    max = count;
                }
                totalRows += count;
            }
            if (max < 0 || totalRows < 3) {
                return 0.0;
            }
            if (this.rowZeroEmpty) {
                return 0.0;
            }
            double consistency = (double)max / (double)totalRows;
            return (1.0 - 1.0 / Math.pow(totalRows, 0.3)) * consistency;
        }
    }

    private static class MutableInt {
        int i;

        MutableInt(int i) {
            this.i = i;
        }

        void increment() {
            ++this.i;
        }

        int intValue() {
            return this.i;
        }
    }

    private static class HitMarkLimitException
    extends EOFException {
        private HitMarkLimitException() {
        }
    }

    private static class UnsurprisingEOF
    extends EOFException {
        private UnsurprisingEOF() {
        }
    }
}

