/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.Barrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.ByModulating;
import org.apache.tinkerpop.gremlin.process.traversal.step.FilteringBarrier;
import org.apache.tinkerpop.gremlin.process.traversal.step.Grouping;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ReducingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.SupplyingBarrierStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.HashMapSupplier;

public final class GroupStep<S, K, V>
extends ReducingBarrierStep<S, Map<K, V>>
implements ByModulating,
TraversalParent,
Grouping<S, K, V> {
    private char state = (char)107;
    private Traversal.Admin<S, K> keyTraversal;
    private Traversal.Admin<S, V> valueTraversal = this.integrateChild(__.fold().asAdmin());
    private Barrier barrierStep = this.determineBarrierStep(this.valueTraversal);

    public GroupStep(Traversal.Admin traversal) {
        super(traversal);
        this.setReducingBiOperator(new GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
        this.setSeedSupplier(HashMapSupplier.instance());
    }

    @Override
    public Traversal.Admin<S, K> getKeyTraversal() {
        return this.keyTraversal;
    }

    @Override
    public Traversal.Admin<S, V> getValueTraversal() {
        return this.valueTraversal;
    }

    private void setValueTraversal(Traversal.Admin kvTraversal) {
        this.valueTraversal = this.integrateChild(this.convertValueTraversal(kvTraversal));
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
        this.setReducingBiOperator(new GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public void resetBarrierFromValueTraversal() {
        this.barrierStep = this.determineBarrierStep(this.valueTraversal);
        this.setReducingBiOperator(new GroupBiOperator(null == this.barrierStep ? Operator.assign : this.barrierStep.getMemoryComputeKey().getReducer()));
    }

    @Override
    public void modulateBy(Traversal.Admin<?, ?> kvTraversal) {
        if ('k' == this.state) {
            this.keyTraversal = this.integrateChild(kvTraversal);
            this.state = (char)118;
        } else if ('v' == this.state) {
            this.setValueTraversal(kvTraversal);
            this.state = (char)120;
        } else {
            throw new IllegalStateException("The key and value traversals for group()-step have already been set: " + this);
        }
    }

    @Override
    public void replaceLocalChild(Traversal.Admin<?, ?> oldTraversal, Traversal.Admin<?, ?> newTraversal) {
        if (null != this.keyTraversal && this.keyTraversal.equals(oldTraversal)) {
            this.keyTraversal = this.integrateChild(newTraversal);
        } else if (null != this.valueTraversal && this.valueTraversal.equals(oldTraversal)) {
            this.setValueTraversal(newTraversal);
        }
    }

    @Override
    public Map<K, V> projectTraverser(Traverser.Admin<S> traverser) {
        HashMap map = new HashMap(1);
        this.valueTraversal.reset();
        this.valueTraversal.addStart(traverser);
        TraversalUtil.produce(traverser, this.keyTraversal).ifProductive(p -> {
            if (null == this.barrierStep) {
                if (this.valueTraversal.hasNext()) {
                    map.put(p, this.valueTraversal.next());
                }
            } else if (this.barrierStep.hasNextBarrier()) {
                map.put(p, this.barrierStep.nextBarrier());
            } else if (this.barrierStep instanceof FilteringBarrier) {
                int barrierStepIndex = TraversalHelper.stepIndex((Step)((Object)this.barrierStep), this.valueTraversal) + 1;
                if (this.valueTraversal.getSteps().stream().skip(barrierStepIndex).anyMatch(step -> step instanceof SupplyingBarrierStep || step instanceof ReducingBarrierStep)) {
                    map.put(p, this.barrierStep.getEmptyBarrier());
                }
            }
        });
        return map;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.keyTraversal, this.valueTraversal);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList children = new ArrayList(2);
        if (null != this.keyTraversal) {
            children.add(this.keyTraversal);
        }
        children.add(this.valueTraversal);
        return children;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT, TraverserRequirement.BULK);
    }

    @Override
    public GroupStep<S, K, V> clone() {
        GroupStep clone = (GroupStep)super.clone();
        if (null != this.keyTraversal) {
            clone.keyTraversal = this.keyTraversal.clone();
        }
        clone.valueTraversal = this.valueTraversal.clone();
        clone.barrierStep = this.determineBarrierStep(clone.valueTraversal);
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.keyTraversal);
        this.integrateChild(this.valueTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (this.keyTraversal != null) {
            result ^= this.keyTraversal.hashCode();
        }
        return result ^= this.valueTraversal.hashCode();
    }

    @Override
    public Map<K, V> generateFinalResult(Map<K, V> object) {
        return this.doFinalReduction(object, this.valueTraversal);
    }

    public static final class GroupBiOperator<K, V>
    implements BinaryOperator<Map<K, V>>,
    Serializable {
        private BinaryOperator<V> barrierAggregator;

        public GroupBiOperator() {
        }

        public GroupBiOperator(BinaryOperator<V> barrierAggregator) {
            this.barrierAggregator = barrierAggregator;
        }

        @Override
        public Map<K, V> apply(Map<K, V> mapA, Map<K, V> mapB) {
            for (K key : mapB.keySet()) {
                Object objectA = mapA.get(key);
                V objectB = mapB.get(key);
                if (null == objectA) {
                    objectA = objectB;
                } else if (null != objectB) {
                    objectA = this.barrierAggregator.apply(objectA, objectB);
                }
                mapA.put(key, objectA);
            }
            return mapA;
        }
    }
}

