import { AuthenticatorOptions } from '../authenticator.cjs';
export type SaslMechanismBaseOptions = AuthenticatorOptions & {
    authzid?: string;
};
export default abstract class SaslMechanismBase {
    protected options: SaslMechanismBaseOptions;
    constructor(options: SaslMechanismBaseOptions);
    /**
     * Returns the name of the mechanism
     */
    get name(): string | null;
    /**
     * Set the options for the mechanism
     * @param {object} options Options specific to the mechanism
     */
    setopts(options: SaslMechanismBaseOptions): void;
    /**
     * Evaluates the challenge from the server and returns appropriate response
     * @param {String} challenge Challenge string presented by the server
     */
    abstract evaluateChallenge(challenge: String): any;
}
