/**
 * @author Jorge Bay Gondra
 */
import { GraphTraversalSource } from '../process/graph-traversal.js';
/**
 * An "empty" graph object to server only as a reference.
 */
export declare class Graph {
    /**
     * Returns the graph traversal source.
     * @param TraversalSourceClass The constructor to use for the {@code GraphTraversalSource} instance.
     * @deprecated As of release 3.3.5, replaced by the traversal() anonymous function.
     */
    traversal(TraversalSourceClass?: typeof GraphTraversalSource): GraphTraversalSource;
    toString(): string;
}
declare class Element<TLabel extends string = string, TId = any> {
    readonly id: TId;
    readonly label: TLabel;
    constructor(id: TId, label: TLabel);
    /**
     * Compares this instance to another and determines if they can be considered as equal.
     */
    equals(other: any): boolean;
}
export declare class Vertex<TLabel extends string = string, TProperties extends Record<string, any> = Record<string, any>, TId = number, TVertexProperties = {
    [P in keyof TProperties]: P extends string ? VertexProperties<P, TProperties[P]> : never;
}> extends Element<TLabel, TId> {
    readonly properties?: TVertexProperties | undefined;
    constructor(id: TId, label: TLabel, properties?: TVertexProperties | undefined);
    toString(): string;
}
export declare class Edge<TOutVertex extends Vertex = Vertex, TLabel extends string = string, TInVertex extends Vertex = Vertex, TProperties extends Record<string, any> = Record<string, any>, TId = number> extends Element<TLabel, TId> {
    readonly outV: TOutVertex;
    readonly label: TLabel;
    readonly inV: TInVertex;
    readonly properties: TProperties;
    constructor(id: TId, outV: TOutVertex, label: TLabel, inV: TInVertex, properties?: TProperties);
    toString(): string;
}
export declare class VertexProperty<TLabel extends string = string, TValue = any, TProperties extends Record<string, any> | null | undefined = Record<string, any>, TId = any> extends Element<TLabel, TId> {
    readonly value: TValue;
    readonly properties?: TProperties | undefined;
    readonly key: string;
    constructor(id: TId, label: TLabel, value: TValue, properties?: TProperties | undefined);
    toString(): string;
}
export type VertexProperties<TLabel extends string = string, TValue = any, TProperties extends Record<string, any> = Record<string, any>, TId = any> = [VertexProperty<TLabel, TValue, TProperties, TId>, ...Array<VertexProperty<TLabel, TValue, TProperties, TId>>];
export declare class Property<T = any> {
    readonly key: string;
    readonly value: T;
    constructor(key: string, value: T);
    toString(): string;
    equals(other: any): boolean;
}
/**
 * Represents a walk through a graph as defined by a traversal.
 */
export declare class Path {
    readonly labels: string[];
    readonly objects: any[];
    constructor(labels: string[], objects: any[]);
    toString(): string;
    equals(other: any): any;
}
export {};
