/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BatchedConsumer;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nonnull;

final class RunLengthEncoder<E>
implements Consumer<E> {
    Object[] array;
    int[] count;
    int arrayIndex;
    int countIndex;

    public RunLengthEncoder(int initialCapacity) {
        this.array = new Object[initialCapacity];
        this.count = new int[initialCapacity];
    }

    @Override
    public void accept(@Nonnull E e) {
        if (this.array[this.arrayIndex] == null) {
            this.array[this.arrayIndex] = e;
            int n = this.countIndex;
            this.count[n] = this.count[n] + 1;
        } else if (this.array[this.arrayIndex] == e) {
            int n = this.countIndex;
            this.count[n] = this.count[n] + 1;
        } else {
            ++this.arrayIndex;
            ++this.countIndex;
            if (this.arrayIndex == this.array.length) {
                int capacity = this.array.length << 1;
                this.array = Arrays.copyOf(this.array, capacity);
                this.count = Arrays.copyOf(this.count, capacity);
            }
            this.array[this.arrayIndex] = e;
            this.count[this.countIndex] = 1;
        }
    }

    public void drainTo(@Nonnull BatchedConsumer<E> consumer) {
        if (this.array[0] == null) {
            return;
        }
        for (int i = 0; i <= this.arrayIndex; ++i) {
            Object e = this.array[i];
            this.array[i] = null;
            int amount = this.count[i];
            this.count[i] = 0;
            consumer.accept(e, amount);
        }
        this.arrayIndex = 0;
        this.countIndex = 0;
    }
}

