/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.ws.spi;

import jakarta.xml.ws.WebServiceException;
import jakarta.xml.ws.spi.ServiceLoaderUtil;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

class FactoryFinder {
    private static final Logger LOGGER;
    private static final ServiceLoaderUtil.ExceptionHandler<WebServiceException> EXCEPTION_HANDLER;
    private static final PrivilegedAction<String> propertyAction;
    private static final String OSGI_SERVICE_LOADER_CLASS_NAME = "org.glassfish.hk2.osgiresourcelocator.ServiceLoader";

    FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String fallbackClassName) {
        ClassLoader classLoader = ServiceLoaderUtil.contextClassLoader(EXCEPTION_HANDLER);
        String factoryId = factoryClass.getName();
        T provider = FactoryFinder.fromSystemProperty(factoryId, fallbackClassName, classLoader);
        if (provider != null) {
            return provider;
        }
        provider = ServiceLoaderUtil.firstByServiceLoader(factoryClass, LOGGER, EXCEPTION_HANDLER);
        if (provider != null) {
            return provider;
        }
        if (FactoryFinder.isOsgi() && (provider = FactoryFinder.lookupUsingOSGiServiceLoader(factoryId)) != null) {
            return provider;
        }
        if (fallbackClassName == null) {
            throw new WebServiceException("Provider for " + factoryId + " cannot be found", null);
        }
        return ServiceLoaderUtil.newInstance(fallbackClassName, fallbackClassName, classLoader, EXCEPTION_HANDLER);
    }

    private static <T> T fromSystemProperty(String factoryId, String fallbackClassName, ClassLoader classLoader) {
        try {
            String systemProp = System.getProperty(factoryId);
            if (systemProp != null) {
                LOGGER.log(Level.FINE, "Found system property {0}", systemProp);
                return FactoryFinder.newInstance(systemProp, fallbackClassName, classLoader);
            }
        }
        catch (SecurityException se) {
            LOGGER.log(Level.SEVERE, "Access is not allowed to the system property with key " + factoryId, se);
        }
        return null;
    }

    private static boolean isOsgi() {
        try {
            Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.log(Level.SEVERE, "Class org.glassfish.hk2.osgiresourcelocator.ServiceLoader cannot be loaded", cnfe);
            return false;
        }
    }

    private static <T> T lookupUsingOSGiServiceLoader(String factoryId) {
        try {
            LOGGER.fine("Trying to create the provider from the OSGi ServiceLoader");
            Class<?> serviceClass = Class.forName(factoryId);
            Class[] args = new Class[]{serviceClass};
            Class<?> target = Class.forName(OSGI_SERVICE_LOADER_CLASS_NAME);
            Method m = target.getMethod("lookupProviderInstances", Class.class);
            Iterator iter = ((Iterable)m.invoke(null, (Object[])args)).iterator();
            return iter.hasNext() ? (T)iter.next() : null;
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Access to the system property with key " + factoryId + " is not allowed", t);
            return null;
        }
    }

    private static <T> T newInstance(String className, String defaultImplClassName, ClassLoader classLoader) {
        Object newInstance = ServiceLoaderUtil.newInstance(className, defaultImplClassName, classLoader, EXCEPTION_HANDLER);
        if (LOGGER.isLoggable(Level.FINE)) {
            Class<?> newInstanceClass = newInstance.getClass();
            LOGGER.log(Level.FINE, "loaded {0} from {1}", new Object[]{newInstanceClass.getName(), FactoryFinder.which(newInstanceClass)});
        }
        return newInstance;
    }

    static URL which(Class<?> clazz) {
        return FactoryFinder.which(clazz, FactoryFinder.getClassClassLoader(clazz));
    }

    static URL which(Class<?> clazz, ClassLoader loader) {
        String classnameAsResource = clazz.getName().replace('.', '/') + ".class";
        if (loader == null) {
            loader = FactoryFinder.getSystemClassLoader();
        }
        return loader.getResource(classnameAsResource);
    }

    private static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(ClassLoader::getSystemClassLoader);
    }

    private static ClassLoader getClassClassLoader(Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(c::getClassLoader);
    }

    static {
        EXCEPTION_HANDLER = new ServiceLoaderUtil.ExceptionHandler<WebServiceException>(){

            @Override
            public WebServiceException createException(Throwable throwable, String message) {
                return new WebServiceException(message, throwable);
            }
        };
        propertyAction = () -> System.getProperty("jax-ws.debug");
        LOGGER = Logger.getLogger("jakarta.xml.ws");
        try {
            if (AccessController.doPrivileged(propertyAction) != null) {
                LOGGER.setUseParentHandlers(false);
                LOGGER.setLevel(Level.ALL);
                ConsoleHandler handler = new ConsoleHandler();
                handler.setLevel(Level.ALL);
                LOGGER.addHandler(handler);
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Exception during loading the class", t);
        }
    }
}

