/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import jakarta.transaction.SystemException;
import javax.transaction.xa.XAException;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.RetryScheduler;

public class RecoverTask
implements Runnable {
    private final RetryScheduler retryScheduler;
    private final NamedXAResourceFactory namedXAResourceFactory;
    private final Recovery recovery;
    private final RecoverableTransactionManager recoverableTransactionManager;
    private int count = 0;

    public RecoverTask(RetryScheduler retryScheduler, NamedXAResourceFactory namedXAResourceFactory, Recovery recovery, RecoverableTransactionManager recoverableTransactionManager) {
        this.retryScheduler = retryScheduler;
        this.namedXAResourceFactory = namedXAResourceFactory;
        this.recovery = recovery;
        this.recoverableTransactionManager = recoverableTransactionManager;
    }

    @Override
    public void run() {
        try {
            NamedXAResource namedXAResource = this.namedXAResourceFactory.getNamedXAResource();
            if (namedXAResource != null) {
                try {
                    this.recovery.recoverResourceManager(namedXAResource);
                }
                finally {
                    this.namedXAResourceFactory.returnNamedXAResource(namedXAResource);
                }
            }
            return;
        }
        catch (XAException e) {
            this.recoverableTransactionManager.recoveryError(e);
        }
        catch (SystemException e) {
            this.recoverableTransactionManager.recoveryError((Exception)((Object)e));
        }
        this.retryScheduler.retry(this, this.count++);
    }
}

