/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.ejb.EJBException;
import jakarta.jms.Message;
import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.State;
import org.apache.openejb.resource.activemq.jms2.DelegateMessage;
import org.apache.openejb.resource.activemq.jms2.JMS2;

abstract class AbstractEndpointHandler
implements InvocationHandler,
MessageEndpoint {
    protected State state = State.NONE;
    protected volatile Boolean isAmq;
    protected Object instance;
    protected final BaseMdbContainer container;

    AbstractEndpointHandler(BaseMdbContainer container) {
        this.container = container;
    }

    public abstract void beforeDelivery(Method var1) throws ApplicationServerInternalException;

    protected abstract void recreateInstance(boolean var1) throws UnavailableException;

    public abstract void release();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object[] parameterTypes = method.getParameterTypes();
        if (method.getDeclaringClass() == Object.class) {
            if ("toString".equals(methodName) && parameterTypes.length == 0) {
                return this.toString();
            }
            if ("equals".equals(methodName) && parameterTypes.length == 1) {
                return this.equals(args[0]);
            }
            if ("hashCode".equals(methodName) && parameterTypes.length == 0) {
                return this.hashCode();
            }
            throw new UnsupportedOperationException("Unkown method: " + String.valueOf(method));
        }
        if ("beforeDelivery".equals(methodName) && Arrays.deepEquals(new Class[]{Method.class}, parameterTypes)) {
            this.beforeDelivery((Method)args[0]);
            return null;
        }
        if ("afterDelivery".equals(methodName) && parameterTypes.length == 0) {
            this.afterDelivery();
            return null;
        }
        if ("release".equals(methodName) && parameterTypes.length == 0) {
            this.release();
            return null;
        }
        Object value = this.deliverMessage(method, args);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Object deliverMessage(Method method, Object[] args) throws Throwable {
        callBeforeAfter = false;
        switch (1.$SwitchMap$org$apache$openejb$core$mdb$State[this.state.ordinal()]) {
            case 1: {
                try {
                    this.beforeDelivery(method);
                }
                catch (ApplicationServerInternalException e) {
                    throw (EJBException)new EJBException().initCause(e.getCause());
                }
                callBeforeAfter = true;
                this.state = State.METHOD_CALLED;
                break;
            }
            case 2: {
                this.state = State.METHOD_CALLED;
                break;
            }
            case 3: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case 4: 
            case 5: {
                throw new IllegalStateException("The last message delivery must be completed with an afterDeliver before another message can be delivered");
            }
        }
        throwable /* !! */  = null;
        value = null;
        try {
            value = this.container.invoke(this.instance, method, null, this.wrapMessageForAmq5(args));
            ** if (!callBeforeAfter) goto lbl-1000
        }
        catch (SystemException se) {
            throwable /* !! */  = se.getRootCause() != null ? se.getRootCause() : se;
            this.state = State.SYSTEM_EXCEPTION;
            ** if (!callBeforeAfter) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    this.afterDelivery();
                }
                catch (ApplicationServerInternalException e) {
                    throwable /* !! */  = throwable /* !! */  == null ? e.getCause() : throwable /* !! */ ;
                }
                catch (UnavailableException e) {
                    throwable /* !! */  = throwable /* !! */  == null ? e : throwable /* !! */ ;
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        catch (ApplicationException ae) {
            v0 /* !! */  = throwable /* !! */  = ae.getRootCause() != null ? ae.getRootCause() : ae;
            ** if (!callBeforeAfter) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    this.afterDelivery();
                }
                catch (ApplicationServerInternalException e) {
                    throwable /* !! */  = throwable /* !! */  == null ? e.getCause() : throwable /* !! */ ;
                }
                catch (UnavailableException e) {
                    throwable /* !! */  = throwable /* !! */  == null ? e : throwable /* !! */ ;
                }
            }
lbl-1000:
            // 2 sources

            {
            }
            {
                catch (Throwable var7_15) {
                    if (callBeforeAfter) {
                        try {
                            this.afterDelivery();
                        }
                        catch (ApplicationServerInternalException e) {
                            throwable /* !! */  = throwable /* !! */  == null ? e.getCause() : throwable /* !! */ ;
                        }
                        catch (UnavailableException e) {
                            throwable /* !! */  = throwable /* !! */  == null ? e : throwable /* !! */ ;
                        }
                    }
                    throw var7_15;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.afterDelivery();
            }
            catch (ApplicationServerInternalException e) {
                throwable /* !! */  = throwable /* !! */  == null ? e.getCause() : throwable /* !! */ ;
            }
            catch (UnavailableException e) {
                throwable /* !! */  = throwable /* !! */  == null ? e : throwable /* !! */ ;
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        if (throwable /* !! */  != null) {
            if (this.isValidException(method, throwable /* !! */ )) {
                throw throwable /* !! */ ;
            }
            throw new EJBException().initCause((Throwable)throwable /* !! */ );
        }
        return value;
    }

    public void afterDelivery() throws ApplicationServerInternalException, UnavailableException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case NONE: {
                throw new IllegalStateException("afterDelivery may only be called if message delivery began with a beforeDelivery call");
            }
        }
        boolean exceptionThrown = false;
        try {
            this.container.afterDelivery(this.instance);
        }
        catch (SystemException se) {
            exceptionThrown = true;
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throw new ApplicationServerInternalException(throwable);
        }
        finally {
            if (this.state == State.SYSTEM_EXCEPTION) {
                this.recreateInstance(exceptionThrown);
            }
            this.state = State.NONE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] wrapMessageForAmq5(Object[] args) {
        if (args == null || args.length != 1 || DelegateMessage.class.isInstance(args[0])) {
            return args;
        }
        if (this.isAmq == null) {
            AbstractEndpointHandler abstractEndpointHandler = this;
            synchronized (abstractEndpointHandler) {
                if (this.isAmq == null) {
                    this.isAmq = args[0].getClass().getName().startsWith("org.apache.activemq.");
                }
            }
        }
        if (this.isAmq.booleanValue()) {
            args[0] = JMS2.wrap((Message)Message.class.cast(args[0]));
        }
        return args;
    }

    private boolean isValidException(Method method, Throwable throwable) {
        Class<?>[] exceptionTypes;
        if (throwable instanceof RuntimeException || throwable instanceof Error) {
            return true;
        }
        for (Class<?> exceptionType : exceptionTypes = method.getExceptionTypes()) {
            if (!exceptionType.isInstance(throwable)) continue;
            return true;
        }
        return false;
    }
}

