/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.tomee.microprofile.jwt.bval.Generated;
import org.apache.tomee.microprofile.jwt.bval.MethodConstraints;
import org.apache.tomee.microprofile.jwt.bval.ValidationGenerator;
import org.apache.xbean.asm9.AnnotationVisitor;
import org.apache.xbean.asm9.ClassWriter;
import org.apache.xbean.asm9.MethodVisitor;
import org.apache.xbean.asm9.Type;

public class ReturnValidationGenerator
extends ValidationGenerator {
    public ReturnValidationGenerator(Class<?> clazz, List<MethodConstraints> constraints) {
        super(clazz, constraints, "ReturnConstraints");
    }

    @Override
    protected void generateMethods(ClassWriter cw) {
        for (MethodConstraints methodConstraints : this.constraints) {
            Method method = methodConstraints.getMethod();
            String name = method.getName();
            Type returnType = Type.getReturnType((Method)method);
            Type[] parameterTypes = Type.getArgumentTypes((Method)method);
            String descriptor = Type.getMethodDescriptor((Type)returnType, (Type[])parameterTypes);
            MethodVisitor mv = cw.visitMethod(1, name, descriptor, null, null);
            AnnotationVisitor av = mv.visitAnnotation(Type.getDescriptor(Generated.class), true);
            av.visit("value", (Object)this.getClass().getName());
            av.visitEnd();
            this.generatedMethods.put(method.getName() + Type.getMethodDescriptor((Method)method), new ValidationGenerator.ConstrainedMethodVisitor(mv, methodConstraints));
            if (method.getReturnType().equals(Void.TYPE)) {
                mv.visitCode();
                mv.visitInsn(177);
                mv.visitMaxs(0, 1);
                continue;
            }
            if (method.getReturnType().equals(Long.TYPE)) {
                mv.visitCode();
                mv.visitInsn(9);
                mv.visitInsn(173);
                mv.visitMaxs(2, 4);
                mv.visitEnd();
                continue;
            }
            if (method.getReturnType().equals(Float.TYPE)) {
                mv.visitCode();
                mv.visitInsn(11);
                mv.visitInsn(174);
                mv.visitMaxs(1, 3);
                mv.visitEnd();
                continue;
            }
            if (method.getReturnType().equals(Double.TYPE)) {
                mv.visitCode();
                mv.visitInsn(14);
                mv.visitInsn(175);
                mv.visitMaxs(2, 4);
                mv.visitEnd();
                continue;
            }
            if (method.getReturnType().isPrimitive()) {
                mv.visitCode();
                mv.visitInsn(3);
                mv.visitInsn(172);
                mv.visitMaxs(1, 3);
                mv.visitEnd();
                continue;
            }
            mv.visitCode();
            mv.visitInsn(1);
            mv.visitInsn(176);
            mv.visitMaxs(1, 1);
        }
    }
}

