/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.impl;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.ElementSupport;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.impl.SignatureImpl;
import org.slf4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureUnmarshaller
implements Unmarshaller {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SignatureUnmarshaller.class);

    public SignatureUnmarshaller() {
        if (!Init.isInitialized()) {
            this.log.debug("Initializing XML security library");
            Init.init();
        }
    }

    @Nonnull
    public Signature unmarshall(@Nonnull Element signatureElement) throws UnmarshallingException {
        this.log.debug("Starting to unmarshall Apache XML-Security-based SignatureImpl element");
        SignatureImpl signature = new SignatureImpl(signatureElement.getNamespaceURI(), signatureElement.getLocalName(), signatureElement.getPrefix());
        try {
            this.log.debug("Constructing Apache XMLSignature object");
            XMLSignature xmlSignature = new XMLSignature(signatureElement, "");
            SignedInfo signedInfo = xmlSignature.getSignedInfo();
            this.log.debug("Adding canonicalization and signing algorithms, and HMAC output length to Signature");
            signature.setCanonicalizationAlgorithm(signedInfo.getCanonicalizationMethodURI());
            signature.setSignatureAlgorithm(signedInfo.getSignatureMethodURI());
            signature.setHMACOutputLength(this.getHMACOutputLengthValue(signedInfo.getSignatureMethodElement()));
            org.apache.xml.security.keys.KeyInfo xmlSecKeyInfo = xmlSignature.getKeyInfo();
            if (xmlSecKeyInfo != null) {
                this.log.debug("Adding KeyInfo to Signature");
                Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().ensureUnmarshaller(xmlSecKeyInfo.getElement());
                KeyInfo keyInfo = (KeyInfo)unmarshaller.unmarshall(xmlSecKeyInfo.getElement());
                signature.setKeyInfo(keyInfo);
            }
            signature.setXMLSignature(xmlSignature);
            signature.setDOM(signatureElement);
            return signature;
        }
        catch (XMLSecurityException e) {
            this.log.error("Error constructing Apache XMLSignature instance from Signature element: {}", (Object)e.getMessage());
            throw new UnmarshallingException("Unable to unmarshall Signature with Apache XMLSignature", (Exception)((Object)e));
        }
    }

    @Nullable
    private Integer getHMACOutputLengthValue(@Nullable Element signatureMethodElement) {
        Element hmacElement;
        String value;
        if (signatureMethodElement == null) {
            return null;
        }
        List children = ElementSupport.getChildElementsByTagNameNS((Node)signatureMethodElement, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"HMACOutputLength");
        if (!children.isEmpty() && (value = StringSupport.trimOrNull((String)(hmacElement = (Element)children.get(0)).getTextContent())) != null) {
            return Integer.valueOf(value);
        }
        return null;
    }
}

