/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.utils.ui;

import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectTypesDialog
extends Dialog
implements Listener {
    private Shell shell;
    private Text typeNameUI;
    private Table list;
    public String typeName = "error-TypeName-never-set";
    private Button okButton;
    private Button cancelButton;
    private List<String> allTypes;
    private List<String> selectedTypes;
    private List<String> initialTypes;

    public SelectTypesDialog(Shell shell, List<String> allTypes, List<String> selectedTypes) {
        super(shell);
        this.shell = shell;
        this.allTypes = allTypes;
        this.selectedTypes = selectedTypes;
        this.initialTypes = new ArrayList<String>(selectedTypes);
        this.createDialogArea();
        this.init();
    }

    protected Control createDialogArea() {
        Composite mainArea = (Composite)this.createDialogArea((Composite)this.shell);
        this.createWideLabel(mainArea, "  Type Name:");
        this.typeNameUI = this.newText(mainArea, 4, "Specify the type name");
        this.typeNameUI.addListener(24, (Listener)this);
        this.createWideLabel(mainArea, "  Matching Types:");
        this.list = this.newTable(mainArea, 32);
        ((GridData)this.list.getLayoutData()).heightHint = 250;
        ((GridData)this.list.getLayoutData()).minimumHeight = 100;
        this.typeNameUI.addListener(32, (Listener)this);
        this.displayFilteredTypes("");
        this.createButtonBar(mainArea);
        return mainArea;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = 3;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        SelectTypesDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000000, 0x1000000, false, false);
        composite.setLayoutData((Object)data);
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, "OK", true);
        this.cancelButton = this.createButton(parent, 1, "    Cancel    ", false);
    }

    private void init() {
        TableItem[] items;
        for (TableItem tableItem : items = this.list.getItems()) {
            if (!this.selectedTypes.contains(tableItem.getText())) continue;
            tableItem.setChecked(true);
        }
        this.okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableItem[] items = SelectTypesDialog.this.list.getItems();
                ArrayList<String> selection = new ArrayList<String>();
                for (TableItem tableItem : items) {
                    if (!tableItem.getChecked()) continue;
                    selection.add(tableItem.getText());
                }
                SelectTypesDialog.this.selectedTypes = selection;
                SelectTypesDialog.this.shell.dispose();
            }
        });
        this.cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectTypesDialog.this.selectedTypes = SelectTypesDialog.this.initialTypes;
                SelectTypesDialog.this.shell.dispose();
            }
        });
        int width = 300;
        int height = 400;
        this.shell.setSize(width, height);
        this.shell.setMinimumSize(300, 300);
        this.shell.setLocation((Toolkit.getDefaultToolkit().getScreenSize().width - width) / 2, (Toolkit.getDefaultToolkit().getScreenSize().height - height) / 2);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.layout();
    }

    protected Label createWideLabel(Composite parent, String message) {
        Label label = null;
        label = new Label(parent, 64);
        label.setText(null != message ? message : "");
        GridData data = new GridData(768);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        data.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text newText(Composite parent, int style, String tip) {
        Text t = new Text(parent, style | 0x800);
        t.setToolTipText(tip);
        t.setLayoutData((Object)new GridData(768));
        t.addListener(2, (Listener)this);
        t.addListener(4, (Listener)this);
        return t;
    }

    protected Table newTable(Composite parent, int style) {
        Table table = new Table(parent, style | 0x800 | 2);
        GridData gd = new GridData(1808);
        table.setLayoutData((Object)gd);
        table.addListener(13, (Listener)this);
        table.addListener(2, (Listener)this);
        return table;
    }

    private void displayFilteredTypes(String aTypeName) {
        this.list.setRedraw(false);
        this.list.removeAll();
        String topEntry = "";
        aTypeName = aTypeName.toLowerCase();
        for (String type : this.allTypes) {
            String candidateTypeName = type.toLowerCase();
            if (!StringUtils.isBlank((CharSequence)aTypeName) && candidateTypeName.indexOf(aTypeName) == -1) continue;
            if (StringUtils.isEmpty((CharSequence)topEntry)) {
                topEntry = type;
            }
            TableItem item = new TableItem(this.list, 0);
            item.setText(type);
            if (!this.selectedTypes.contains(item.getText())) continue;
            item.setChecked(true);
        }
        this.list.setRedraw(true);
    }

    public void handleEvent(Event event) {
        Widget item;
        if (event.widget == this.typeNameUI && event.type == 24) {
            this.displayFilteredTypes(this.typeNameUI.getText());
        } else if (event.widget == this.list && (item = event.item) instanceof TableItem) {
            TableItem[] selection;
            TableItem ti = (TableItem)item;
            for (TableItem tableItem : selection = this.list.getSelection()) {
                if (tableItem == ti) continue;
                if (ti.getChecked()) {
                    tableItem.setChecked(true);
                    this.selectedTypes.add(tableItem.getText());
                    continue;
                }
                this.selectedTypes.remove(tableItem.getText());
                tableItem.setChecked(false);
            }
            if (ti.getChecked()) {
                this.selectedTypes.add(ti.getText());
            } else {
                this.selectedTypes.remove(ti.getText());
            }
        }
    }

    public boolean isValid() {
        return true;
    }

    public List<String> getSelectedTypes() {
        return this.selectedTypes;
    }

    public void setSelectedTypes(List<String> selectedTypes) {
        this.selectedTypes = selectedTypes;
    }
}

