/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.string;

import java.util.List;
import org.antlr.runtime.RecognitionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.core.extensions.IIDEStringFunctionExtension;
import org.apache.uima.ruta.ide.core.extensions.IRutaCheckerProblemFactory;
import org.apache.uima.ruta.ide.parser.ast.RutaFunction;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;

public class StringOperationsIDEExtension
implements IIDEStringFunctionExtension {
    private final String[] strings = new String[]{"toUpperCase", "toLowerCase", "replaceFirst", "replaceAll", "substring", "firstCharToUpperCase"};

    public String[] getKnownExtensions() {
        return this.strings;
    }

    public boolean checkSyntax(Expression element, IRutaCheckerProblemFactory problemFactory, IProblemReporter rep) throws RecognitionException {
        if (element instanceof RutaFunction) {
            IProblem problem;
            RutaFunction f = (RutaFunction)element;
            String name = f.getName();
            List childs = f.getChilds();
            boolean ok = true;
            if (StringUtils.equals((CharSequence)name, (CharSequence)this.strings[0]) || StringUtils.equals((CharSequence)name, (CharSequence)this.strings[1]) || StringUtils.equals((CharSequence)name, (CharSequence)this.strings[5])) {
                if (childs.size() != 1) {
                    problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 1);
                    rep.reportProblem(problem);
                    ok = false;
                }
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)this.strings[2]) || StringUtils.equals((CharSequence)name, (CharSequence)this.strings[3]) || StringUtils.equals((CharSequence)name, (CharSequence)this.strings[4])) {
                if (childs.size() != 3) {
                    problem = problemFactory.createWrongNumberOfArgumentsProblem(name, element, 3);
                    rep.reportProblem(problem);
                    ok = false;
                }
            } else {
                IProblem problem2 = problemFactory.createUnknownFunctionProblem(f);
                rep.reportProblem(problem2);
                return false;
            }
            if (StringUtils.equals((CharSequence)name, (CharSequence)this.strings[4])) {
                Expression expr2;
                Expression expr1;
                Expression expr0 = (Expression)childs.get(0);
                if (expr0.getKind() != 0x200000 && expr0.getKind() != -1) {
                    IProblem problem3 = problemFactory.createWrongArgumentTypeProblem(expr0, "StringExpression");
                    rep.reportProblem(problem3);
                    ok = false;
                }
                if ((expr1 = (Expression)childs.get(1)).getKind() != 262144 && expr1.getKind() != -1) {
                    IProblem problem4 = problemFactory.createWrongArgumentTypeProblem(expr1, "NumberExpression");
                    rep.reportProblem(problem4);
                    ok = false;
                }
                if ((expr2 = (Expression)childs.get(2)).getKind() != 262144 && expr2.getKind() != -1) {
                    IProblem problem5 = problemFactory.createWrongArgumentTypeProblem(expr2, "NumberExpression");
                    rep.reportProblem(problem5);
                    ok = false;
                }
            } else {
                for (ASTNode astNode : childs) {
                    Expression expr = (Expression)astNode;
                    if (expr.getKind() == 0x200000 || expr.getKind() == -1) continue;
                    IProblem problem6 = problemFactory.createWrongArgumentTypeProblem(expr, "StringExpression");
                    rep.reportProblem(problem6);
                    ok = false;
                }
            }
            return ok;
        }
        return false;
    }
}

