/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.com.github.benmanes.caffeine.cache;

import java.lang.ref.ReferenceQueue;
import org.apache.camel.com.github.benmanes.caffeine.base.UnsafeAccess;
import org.apache.camel.com.github.benmanes.caffeine.cache.FW;
import org.apache.camel.com.github.benmanes.caffeine.cache.Node;

class FWW<K, V>
extends FW<K, V> {
    protected static final long WRITE_TIME_OFFSET = UnsafeAccess.objectFieldOffset(FWW.class, "writeTime");
    volatile long writeTime;
    Node<K, V> previousInWriteOrder;
    Node<K, V> nextInWriteOrder;

    FWW() {
    }

    FWW(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        super(k, referenceQueue, v, referenceQueue2, n, l);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    FWW(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        super(object, v, referenceQueue, n, l);
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> node) {
        this.previousInWriteOrder = node;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> node) {
        this.nextInWriteOrder = node;
    }

    @Override
    public long getVariableTime() {
        return this.writeTime;
    }

    @Override
    public void setVariableTime(long l) {
        this.writeTime = l;
    }

    @Override
    public final long getWriteTime() {
        return UnsafeAccess.UNSAFE.getLong(this, WRITE_TIME_OFFSET);
    }

    @Override
    public final void setWriteTime(long l) {
        UnsafeAccess.UNSAFE.putLong(this, WRITE_TIME_OFFSET, l);
    }

    @Override
    public final Node<K, V> getPreviousInWriteOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public final void setPreviousInWriteOrder(Node<K, V> node) {
        this.previousInWriteOrder = node;
    }

    @Override
    public final Node<K, V> getNextInWriteOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public final void setNextInWriteOrder(Node<K, V> node) {
        this.nextInWriteOrder = node;
    }

    @Override
    public Node<K, V> newNode(K k, ReferenceQueue<K> referenceQueue, V v, ReferenceQueue<V> referenceQueue2, int n, long l) {
        return new FWW<K, V>(k, referenceQueue, v, referenceQueue2, n, l);
    }

    @Override
    public Node<K, V> newNode(Object object, V v, ReferenceQueue<V> referenceQueue, int n, long l) {
        return new FWW<K, V>(object, v, referenceQueue, n, l);
    }
}

