/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.List;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.license.ApacheLicenseHeaderTestCase;
import org.apache.wicket.util.license.ILicenseHeaderHandler;
import org.apache.wicket.util.string.Strings;

abstract class AbstractLicenseHeaderHandler
implements ILicenseHeaderHandler {
    protected static final String LINE_ENDING = System.getProperty("line.separator");
    private final List<String> ignoreFiles;
    private String licenseHeader;

    public AbstractLicenseHeaderHandler(List<String> ignoreFiles) {
        this.ignoreFiles = ignoreFiles;
    }

    @Override
    public List<String> getIgnoreFiles() {
        return this.ignoreFiles;
    }

    @Override
    public boolean addLicenseHeader(File file) {
        System.out.println("Not supported yet.");
        return false;
    }

    @Override
    public String getLicenseType(File file) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String extractLicenseHeader(File file, int start, int length) {
        StringBuilder header = new StringBuilder();
        LineNumberReader lineNumberReader = null;
        try {
            FileReader fileReader = new FileReader(file);
            lineNumberReader = new LineNumberReader(fileReader);
            for (int i = start; i < length; ++i) {
                header.append(lineNumberReader.readLine());
                header.append(LINE_ENDING);
            }
        }
        catch (Exception e) {
            try {
                throw new AssertionError((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    IOUtils.close(lineNumberReader);
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new AssertionError((Object)e2.getMessage());
                }
            }
        }
        try {
            IOUtils.close(lineNumberReader);
            return header.toString().trim();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    protected void prependLicenseHeader(File file) {
        try {
            Object content = new org.apache.wicket.util.file.File(file).readString();
            content = this.getLicenseHeader() + LINE_ENDING + (String)content;
            new org.apache.wicket.util.file.File(file).write((String)content);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
    }

    protected String getLicenseHeader() {
        if (Strings.isEmpty(this.licenseHeader)) {
            LineNumberReader lineNumberReader = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            try {
                inputStream = ApacheLicenseHeaderTestCase.class.getResourceAsStream(this.getLicenseHeaderFilename());
                inputStreamReader = new InputStreamReader(inputStream);
                lineNumberReader = new LineNumberReader(inputStreamReader);
                StringBuilder header = new StringBuilder();
                String line = lineNumberReader.readLine();
                while (line != null) {
                    header.append(line);
                    header.append(LINE_ENDING);
                    line = lineNumberReader.readLine();
                }
                this.licenseHeader = header.toString().trim();
            }
            catch (Exception e) {
                try {
                    throw new AssertionError((Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(lineNumberReader);
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly(inputStreamReader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(lineNumberReader);
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(inputStreamReader);
        }
        return this.licenseHeader;
    }

    protected abstract String getLicenseHeaderFilename();
}

