/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.util.HashSet;
import java.util.Iterator;
import org.apache.wicket.Component;
import org.apache.wicket.DequeueContext;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepeater
extends WebMarkupContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractRepeater.class);

    public AbstractRepeater(String id) {
        super(id);
    }

    public AbstractRepeater(String id, IModel<?> model) {
        super(id, model);
    }

    protected abstract Iterator<? extends Component> renderIterator();

    @Override
    protected final void onRender() {
        Iterator<? extends Component> it = this.renderIterator();
        while (it.hasNext()) {
            Component child = it.next();
            if (child == null) {
                throw new IllegalStateException("The render iterator returned null for a child. Container: " + this.toString() + "; Iterator=" + it.toString());
            }
            this.renderChild(child);
        }
    }

    protected void renderChild(Component child) {
        child.render();
    }

    @Override
    protected void onBeforeRender() {
        this.onPopulate();
        if (this.getApplication().usesDevelopmentConfig()) {
            HashSet<String> usedComponentIds = new HashSet<String>();
            for (Component c : this) {
                String componentId = c.getId();
                if (usedComponentIds.add(componentId)) continue;
                log.warn("Repeater '{}' has multiple children with the same component id: '{}'", (Object)this.getPageRelativePath(), (Object)componentId);
                break;
            }
        }
        super.onBeforeRender();
    }

    @Override
    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkup();
    }

    protected abstract void onPopulate();

    @Override
    public void dequeue(DequeueContext dequeue) {
        if (this.size() > 0) {
            DequeueContext.Bookmark bookmark = dequeue.save();
            for (Component child : this) {
                if (!(child instanceof MarkupContainer)) continue;
                dequeue.popContainer();
                MarkupContainer container = (MarkupContainer)child;
                dequeue.pushContainer(container);
                container.dequeue(dequeue);
                dequeue.restore(bookmark);
            }
        }
        dequeue.skipToCloseTag();
    }
}

