/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.form.datetime;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import org.apache.wicket.Component;
import org.apache.wicket.core.util.string.CssUtils;
import org.apache.wicket.extensions.markup.html.form.datetime.LocalDateTextField;
import org.apache.wicket.extensions.markup.html.form.datetime.TimeField;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.validation.IValidationError;

abstract class AbstractDateTimeField<T extends Temporal>
extends FormComponentPanel<T> {
    private static final long serialVersionUID = 1L;
    public static final String DATE_CSS_CLASS_KEY = CssUtils.key(AbstractDateTimeField.class, (String)"date");
    public static final String TIME_CSS_CLASS_KEY = CssUtils.key(AbstractDateTimeField.class, (String)"time");
    private LocalDateTextField localDateField;
    private TimeField timeField;

    public AbstractDateTimeField(String id) {
        this(id, null);
    }

    public AbstractDateTimeField(String id, IModel<T> model) {
        super(id, model);
        this.add(new Component[]{new Label("timeSeparator", (IModel)new ResourceModel("AbstractDateTimeField.timeSeparator")){
            private static final long serialVersionUID = 1L;

            protected void onConfigure() {
                super.onConfigure();
                AbstractDateTimeField.this.timeField.configure();
                this.setVisible(AbstractDateTimeField.this.timeField.isVisible());
            }
        }});
    }

    protected void onInitialize() {
        super.onInitialize();
        Component[] componentArray = new Component[1];
        this.localDateField = this.newDateField("date", new DateModel());
        componentArray[0] = this.localDateField;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.timeField = this.newTimeField("time", new TimeModel());
        componentArray2[0] = this.timeField;
        this.add(componentArray2);
    }

    protected final LocalDateTextField getDateField() {
        return this.localDateField;
    }

    protected final TimeField getTimeField() {
        return this.timeField;
    }

    public String getInput() {
        return String.format("%s, %s", this.localDateField.getInput(), this.timeField.getInput());
    }

    public void convertInput() {
        Object temporal;
        LocalDate date = (LocalDate)this.localDateField.getConvertedInput();
        LocalTime time = (LocalTime)this.timeField.getConvertedInput();
        if (date == null && time == null) {
            temporal = null;
        } else {
            if (date == null) {
                this.error((IValidationError)this.newValidationError(new ConversionException("Cannot create temporal without date").setTargetType(this.getType())));
                return;
            }
            if (time == null && (time = this.getDefaultTime()) == null) {
                this.error((IValidationError)this.newValidationError(new ConversionException("Cannot create temporal without time").setTargetType(this.getType())));
                return;
            }
            temporal = this.createTemporal(date, time);
        }
        this.setConvertedInput(temporal);
    }

    protected LocalTime getDefaultTime() {
        return null;
    }

    protected LocalDateTextField newDateField(String id, IModel<LocalDate> dateFieldModel) {
        return new LocalDateTextField(id, dateFieldModel, FormatStyle.SHORT){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)this.getString(DATE_CSS_CLASS_KEY), " ");
            }
        };
    }

    protected TimeField newTimeField(String id, IModel<LocalTime> timeFieldModel) {
        return new TimeField(id, timeFieldModel){
            private static final long serialVersionUID = 1L;

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.append("class", (CharSequence)this.getString(TIME_CSS_CLASS_KEY), " ");
            }
        };
    }

    protected void onBeforeRender() {
        this.localDateField.setRequired(this.isRequired());
        this.timeField.setRequired(this.isRequired());
        super.onBeforeRender();
    }

    protected abstract LocalDate getLocalDate(T var1);

    protected abstract LocalTime getLocalTime(T var1);

    protected abstract T createTemporal(LocalDate var1, LocalTime var2);

    private class TimeModel
    implements IModel<LocalTime> {
        private static final long serialVersionUID = 1L;

        private TimeModel() {
        }

        public LocalTime getObject() {
            Temporal temporal = (Temporal)AbstractDateTimeField.this.getModelObject();
            if (temporal == null) {
                return null;
            }
            return AbstractDateTimeField.this.getLocalTime(temporal);
        }

        public void setObject(LocalTime time) {
        }
    }

    private class DateModel
    implements IModel<LocalDate> {
        private static final long serialVersionUID = 1L;

        private DateModel() {
        }

        public LocalDate getObject() {
            Temporal temporal = (Temporal)AbstractDateTimeField.this.getModelObject();
            if (temporal == null) {
                return null;
            }
            return AbstractDateTimeField.this.getLocalDate(temporal);
        }

        public void setObject(LocalDate date) {
        }
    }
}

