/*
 * TOCTemplate.java
 *
 * Brazil project web application toolkit,
 * export version: 2.1 
 * Copyright (c) 1999-2003 Sun Microsystems, Inc.
 *
 * Sun Public License Notice
 *
 * The contents of this file are subject to the Sun Public License Version 
 * 1.0 (the "License"). You may not use this file except in compliance with 
 * the License. A copy of the License is included as the file "license.terms",
 * and also available at http://www.sun.com/
 * 
 * The Original Code is from:
 *    Brazil project web application toolkit release 2.1.
 * The Initial Developer of the Original Code is: suhler.
 * Portions created by suhler are Copyright (C) Sun Microsystems, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s): cstevens, suhler.
 *
 * Version:  2.2
 * Created by suhler on 99/09/01
 * Last modified by suhler on 03/07/07 14:02:52
 */

package sunlabs.brazil.template;

/**
 * Template class for extracting table of contents information
 * out of an html page by examining the "H1" tags, and setting
 * request properties that can be used to build a table of contents.
 * This class is used by the TemplateHandler.
 *
 * @author		Stephen Uhler
 * @version		@(#)TOCTemplate.java	2.2
 */

public class TOCTemplate
    extends Template
{
    StringBuffer extract;	// the extracted TOC
    int count = 0;

    public boolean
    init(RewriteContext hr)
    {
	extract = new StringBuffer();
	count = 0;
	return true;
    }

    /**
     * Add a name anchor to the H1 tag, so we can go there, 
     * and set the request properties:<code>TOC.[anchor]</code>
     * to the text of the <code>H1</code> tag.
     */

    public void
    tag_h1(RewriteContext hr)
    {
	String propName = "h1_toc_" +  ++count;
	hr.append("<a name=" + propName +"></a>");
	hr.appendToken();

	while (hr.nextToken()) {
	    String tag = hr.getTag();
	    if (hr.isClosingFor("h1")) {
		break;
	    }
	    extract.append(hr.getToken());
	}
	hr.request.props.put("TOC." + propName, extract.toString());
	extract.setLength(0);
    }
}
