/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import com.google.common.collect.ImmutableList;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.buildevents.ContextAwareExceptionHandler;
import org.gradle.internal.buildevents.ExceptionContextVisitor;
import org.gradle.internal.enterprise.core.GradleEnterprisePluginManager;
import org.gradle.internal.exceptions.CompilationFailedIndicator;
import org.gradle.internal.exceptions.ContextAwareException;
import org.gradle.internal.exceptions.FailureResolutionAware;
import org.gradle.internal.exceptions.NonGradleCause;
import org.gradle.internal.exceptions.NonGradleCauseExceptionsHolder;
import org.gradle.internal.exceptions.ResolutionProvider;
import org.gradle.internal.exceptions.StyledException;
import org.gradle.internal.logging.text.BufferingStyledTextOutput;
import org.gradle.internal.logging.text.LinePrefixingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.problems.failure.Failure;
import org.gradle.internal.problems.failure.FailureFactory;
import org.gradle.problems.internal.rendering.ProblemWriter;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class BuildExceptionReporter
implements Action<Throwable> {
    private static final String NO_ERROR_MESSAGE_INDICATOR = "(no error message)";
    public static final String RESOLUTION_LINE_PREFIX = "> ";
    public static final String LINE_PREFIX_LENGTH_SPACES = StringUtils.repeat((String)" ", (int)"> ".length());
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;
    private final GradleEnterprisePluginManager gradleEnterprisePluginManager;
    private final FailureFactory failureFactory;

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData, @Nullable GradleEnterprisePluginManager gradleEnterprisePluginManager, FailureFactory failureFactory) {
        this.textOutputFactory = textOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = clientMetaData;
        this.gradleEnterprisePluginManager = gradleEnterprisePluginManager;
        this.failureFactory = failureFactory;
    }

    public BuildExceptionReporter(StyledTextOutputFactory textOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData clientMetaData, FailureFactory failureFactory) {
        this(textOutputFactory, loggingConfiguration, clientMetaData, null, failureFactory);
    }

    public void buildFinished(@Nullable Failure failure) {
        if (failure == null) {
            return;
        }
        this.renderFailure(failure);
    }

    public void execute(@NonNull Throwable throwable) {
        Failure failure = this.failureFactory.create(throwable);
        this.renderFailure(failure);
    }

    private void renderFailure(@NonNull Failure failure) {
        List causes = failure.getCauses();
        if (causes.size() > 1) {
            this.renderMultipleBuildExceptions(failure);
        } else {
            this.renderSingleBuildException(failure);
        }
    }

    private void renderMultipleBuildExceptions(Failure failure) {
        String message = failure.getMessage();
        List flattenedFailures = failure.getCauses();
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).format("FAILURE: %s", new Object[]{message});
        output.println();
        for (int i = 0; i < flattenedFailures.size(); ++i) {
            Failure cause = (Failure)flattenedFailures.get(i);
            FailureDetails details = this.constructFailureDetails("Task", cause);
            output.println();
            output.withStyle(StyledTextOutput.Style.Failure).format("%s: ", new Object[]{i + 1});
            details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
            output.println();
            output.text((Object)"-----------");
            BuildExceptionReporter.writeFailureDetails(output, details);
            output.println((Object)"==============================================================================");
        }
    }

    private void renderSingleBuildException(Failure failure) {
        StyledTextOutput output = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        FailureDetails details = this.constructFailureDetails("Build", failure);
        output.println();
        output.withStyle(StyledTextOutput.Style.Failure).text((Object)"FAILURE: ");
        details.summary.writeTo(output.withStyle(StyledTextOutput.Style.Failure));
        output.println();
        BuildExceptionReporter.writeFailureDetails(output, details);
    }

    private static boolean hasCauseAncestry(Failure failure, Class<?> type) {
        ArrayDeque causes = new ArrayDeque(failure.getCauses());
        while (!causes.isEmpty()) {
            Failure cause = (Failure)causes.pop();
            if (BuildExceptionReporter.hasCause(cause, type)) {
                return true;
            }
            causes.addAll(cause.getCauses());
        }
        return false;
    }

    private static boolean hasCause(Failure cause, Class<?> type) {
        if (NonGradleCauseExceptionsHolder.class.isAssignableFrom(cause.getExceptionType())) {
            return ((NonGradleCauseExceptionsHolder)cause.getOriginal()).hasCause(type);
        }
        return false;
    }

    private ExceptionStyle getShowStackTraceOption() {
        if (this.loggingConfiguration.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            return ExceptionStyle.FULL;
        }
        return ExceptionStyle.NONE;
    }

    private FailureDetails constructFailureDetails(String granularity, Failure failure) {
        FailureDetails details = new FailureDetails(failure, this.getShowStackTraceOption());
        details.summary.format("%s failed with an exception.", new Object[]{granularity});
        this.fillInFailureResolution(details);
        if (failure.getOriginal() instanceof ContextAwareException) {
            ExceptionFormattingVisitor exceptionFormattingVisitor = new ExceptionFormattingVisitor(details);
            ContextAwareExceptionHandler.visit(failure, exceptionFormattingVisitor);
        } else {
            details.appendDetails();
        }
        details.renderStackTrace();
        return details;
    }

    private void fillInFailureResolution(FailureDetails details) {
        LogLevel logLevel;
        boolean isLessThanInfo;
        boolean shouldDisplayGenericResolutions;
        ContextImpl context = new ContextImpl(details.resolution);
        if (details.failure.getOriginal() instanceof FailureResolutionAware) {
            ((FailureResolutionAware)((Object)details.failure.getOriginal())).appendResolutions(context);
        }
        BuildExceptionReporter.getResolutions(details.failure).stream().distinct().forEach(resolution -> context.appendResolution(output -> output.text((Object)String.join((CharSequence)("\n " + LINE_PREFIX_LENGTH_SPACES), resolution.split("\n")))));
        boolean bl = shouldDisplayGenericResolutions = !BuildExceptionReporter.hasCauseAncestry(details.failure, NonGradleCause.class) && !BuildExceptionReporter.hasProblemReportsWithSolutions(details.failure);
        if (details.exceptionStyle == ExceptionStyle.NONE && shouldDisplayGenericResolutions) {
            context.appendResolution(output -> BuildExceptionReporter.runWithOption(output, "stacktrace", " option to get the stack trace."));
        }
        boolean bl2 = isLessThanInfo = (logLevel = this.loggingConfiguration.getLogLevel()).ordinal() > LogLevel.INFO.ordinal();
        if (logLevel != LogLevel.DEBUG && shouldDisplayGenericResolutions) {
            context.appendResolution(output -> {
                output.text((Object)"Run with ");
                if (isLessThanInfo) {
                    output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"info"});
                    output.text((Object)" or ");
                }
                output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{"debug"});
                output.text((Object)" option to get more log output.");
            });
        }
        if (!context.missingBuild && !this.isGradleEnterprisePluginApplied()) {
            this.addBuildScanMessage(context);
        }
        if (shouldDisplayGenericResolutions) {
            context.appendResolution(BuildExceptionReporter::writeGeneralTips);
        }
    }

    private static boolean hasProblemReportsWithSolutions(Failure failure) {
        Optional solution = failure.getProblems().stream().flatMap(p -> p.getSolutions().stream()).findFirst();
        if (solution.isPresent()) {
            return true;
        }
        return BuildExceptionReporter.hasProblemReportsWithSolutions(failure.getCauses());
    }

    private static boolean hasProblemReportsWithSolutions(List<Failure> failures) {
        return failures.stream().anyMatch(BuildExceptionReporter::hasProblemReportsWithSolutions);
    }

    private static void runWithOption(StyledTextOutput output, String optionName, String text) {
        output.text((Object)"Run with ");
        output.withStyle(StyledTextOutput.Style.UserInput).format("--%s", new Object[]{optionName});
        output.text((Object)text);
    }

    private static List<String> getResolutions(Failure failure) {
        ImmutableList.Builder resolutions = ImmutableList.builder();
        if (ResolutionProvider.class.isAssignableFrom(failure.getExceptionType())) {
            resolutions.addAll((Iterable)((ResolutionProvider)failure.getOriginal()).getResolutions());
        }
        List all = failure.getProblems();
        for (InternalProblem problem : all) {
            ProblemGroup group = problem.getDefinition().getId().getGroup();
            if (GradleCoreProblemGroup.validation().type().equals(group) || GradleCoreProblemGroup.validation().property().equals(group)) continue;
            resolutions.addAll((Iterable)problem.getSolutions());
            if (problem.getDefinition().getDocumentationLink() == null) continue;
            resolutions.add((Object)("For more information, see " + problem.getDefinition().getDocumentationLink().getUrl()));
        }
        for (Failure cause : failure.getCauses()) {
            resolutions.addAll(BuildExceptionReporter.getResolutions(cause));
        }
        return resolutions.build();
    }

    private void addBuildScanMessage(ContextImpl context) {
        context.appendResolution(output -> BuildExceptionReporter.runWithOption(output, "scan", " to get full insights from a Build Scan (powered by Develocity)."));
    }

    private boolean isGradleEnterprisePluginApplied() {
        return this.gradleEnterprisePluginManager != null && this.gradleEnterprisePluginManager.isPresent();
    }

    private static void writeGeneralTips(StyledTextOutput resolution) {
        resolution.text((Object)"Get more help at ");
        resolution.withStyle(StyledTextOutput.Style.UserInput).text((Object)"https://help.gradle.org");
        resolution.text((Object)".");
    }

    private static String getMessage(Failure failure) {
        try {
            String msg = failure.getMessage();
            StringBuilder builder = new StringBuilder();
            List problems = failure.getProblems();
            if (!problems.isEmpty()) {
                String diagnosticCounts;
                if (failure.getOriginal() instanceof CompilationFailedIndicator) {
                    builder.append(msg == null ? "" : msg);
                    builder.append(System.lineSeparator());
                }
                StringWriter problemWriter = new StringWriter();
                ProblemWriter.grouping().write((Collection)problems, (Writer)problemWriter);
                builder.append(problemWriter);
                if (failure.getOriginal() instanceof CompilationFailedIndicator && (diagnosticCounts = ((CompilationFailedIndicator)failure.getOriginal()).getDiagnosticCounts()) != null) {
                    builder.append(System.lineSeparator());
                    builder.append(diagnosticCounts);
                }
            } else {
                builder.append(msg == null ? "" : msg);
            }
            String message = builder.toString();
            if (GUtil.isTrue((Object)message)) {
                return message;
            }
            return String.format("%s %s", failure.getExceptionType().getName(), NO_ERROR_MESSAGE_INDICATOR);
        }
        catch (Throwable t) {
            return String.format("Unable to get message for failure of type %s due to %s", failure.getExceptionType().getSimpleName(), t.getMessage());
        }
    }

    private static void writeFailureDetails(StyledTextOutput output, FailureDetails details) {
        BuildExceptionReporter.writeSection(details.location, output, "* Where:");
        BuildExceptionReporter.writeSection(details.details, output, "* What went wrong:");
        BuildExceptionReporter.writeSection(details.resolution, output, "* Try:");
        BuildExceptionReporter.writeSection(details.stackTrace, output, "* Exception is:");
    }

    private static void writeSection(BufferingStyledTextOutput textOutput, StyledTextOutput output, String sectionTitle) {
        if (textOutput.getHasContent()) {
            output.println();
            output.println((Object)sectionTitle);
            textOutput.writeTo(output);
            output.println();
        }
    }

    static void renderStyledError(Failure failure, StyledTextOutput details) {
        if (failure.getOriginal() instanceof StyledException) {
            ((StyledException)((Object)failure.getOriginal())).render(details);
        } else {
            details.text((Object)BuildExceptionReporter.getMessage(failure));
        }
    }

    @NullMarked
    private static class FailureDetails {
        Failure failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput stackTrace = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        final ExceptionStyle exceptionStyle;

        public FailureDetails(Failure failure, ExceptionStyle exceptionStyle) {
            this.failure = failure;
            this.exceptionStyle = exceptionStyle;
        }

        void appendDetails() {
            BuildExceptionReporter.renderStyledError(this.failure.withoutProblems(), (StyledTextOutput)this.details);
        }

        void renderStackTrace() {
            if (this.exceptionStyle == ExceptionStyle.FULL) {
                try {
                    this.stackTrace.failure(this.failure);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @NullMarked
    private static enum ExceptionStyle {
        NONE,
        FULL;

    }

    private static class ExceptionFormattingVisitor
    extends ExceptionContextVisitor {
        private final FailureDetails failureDetails;
        private final Set<Throwable> printedNodes = new HashSet<Throwable>();
        private int depth;
        private int suppressedDuplicateBranchCount;

        private ExceptionFormattingVisitor(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
        }

        @Override
        protected void visitCause(Failure cause) {
            this.failureDetails.failure = cause;
            this.failureDetails.appendDetails();
        }

        @Override
        protected void visitLocation(String location) {
            this.failureDetails.location.text((Object)location);
        }

        @Override
        public void node(Failure node) {
            if (this.shouldBePrinted(node)) {
                this.printedNodes.add(node.getOriginal());
                if (node.getCauses().isEmpty() || ExceptionFormattingVisitor.isUsefulMessage(BuildExceptionReporter.getMessage(node))) {
                    LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
                    BuildExceptionReporter.renderStyledError(node, (StyledTextOutput)output);
                }
            } else if (node.getCauses().isEmpty()) {
                ++this.suppressedDuplicateBranchCount;
            }
        }

        private boolean shouldBePrinted(Failure node) {
            if (this.printedNodes.isEmpty()) {
                return true;
            }
            ArrayDeque<Failure> next = new ArrayDeque<Failure>();
            next.add(node);
            while (!next.isEmpty()) {
                Failure curr = (Failure)next.poll();
                if (this.printedNodes.contains(curr.getOriginal())) {
                    return false;
                }
                if (!curr.getCauses().isEmpty()) {
                    next.add((Failure)curr.getCauses().get(0));
                }
                if (!(curr.getOriginal() instanceof ContextAwareException)) continue;
                next.addAll(ContextAwareExceptionHandler.getReportableCauses(curr));
            }
            return true;
        }

        private static boolean isUsefulMessage(String message) {
            return StringUtils.isNotBlank((CharSequence)message) && !message.endsWith(BuildExceptionReporter.NO_ERROR_MESSAGE_INDICATOR);
        }

        @Override
        public void startChildren() {
            ++this.depth;
        }

        @Override
        public void endChildren() {
            --this.depth;
        }

        private LinePrefixingStyledTextOutput getLinePrefixingStyledTextOutput(FailureDetails details) {
            details.details.format("%n", new Object[0]);
            StringBuilder prefix = new StringBuilder(StringUtils.repeat((String)"   ", (int)(this.depth - 1)));
            details.details.text((Object)prefix);
            prefix.append("  ");
            details.details.style(StyledTextOutput.Style.Info).text((Object)BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            return new LinePrefixingStyledTextOutput((StyledTextOutput)details.details, (CharSequence)prefix, false);
        }

        @Override
        protected void endVisiting() {
            if (this.suppressedDuplicateBranchCount > 0) {
                boolean plural;
                LinePrefixingStyledTextOutput output = this.getLinePrefixingStyledTextOutput(this.failureDetails);
                boolean bl = plural = this.suppressedDuplicateBranchCount > 1;
                if (plural) {
                    output.append((CharSequence)String.format("There are %d more failures with identical causes.", this.suppressedDuplicateBranchCount));
                } else {
                    output.append((CharSequence)"There is 1 more failure with an identical cause.");
                }
            }
        }
    }

    @NullMarked
    private class ContextImpl
    implements FailureResolutionAware.Context {
        private final BufferingStyledTextOutput resolution;
        private final DocumentationRegistry documentationRegistry = new DocumentationRegistry();
        private boolean missingBuild;

        public ContextImpl(BufferingStyledTextOutput resolution) {
            this.resolution = resolution;
        }

        @Override
        public BuildClientMetaData getClientMetaData() {
            return BuildExceptionReporter.this.clientMetaData;
        }

        @Override
        public void doNotSuggestResolutionsThatRequireBuildDefinition() {
            this.missingBuild = true;
        }

        @Override
        public void appendResolution(Consumer<StyledTextOutput> resolutionProducer) {
            if (this.resolution.getHasContent()) {
                this.resolution.println();
            }
            this.resolution.style(StyledTextOutput.Style.Info).text((Object)BuildExceptionReporter.RESOLUTION_LINE_PREFIX).style(StyledTextOutput.Style.Normal);
            resolutionProducer.accept((StyledTextOutput)this.resolution);
        }

        @Override
        public void appendDocumentationResolution(String prefix, String userGuideId, String userGuideSection) {
            this.appendResolution(output -> output.text((Object)this.documentationRegistry.getDocumentationRecommendationFor(prefix, userGuideId, userGuideSection)));
        }
    }
}

